/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.SocketProxyAgent;

import jade.core.Agent;
import jade.tools.SocketProxyAgent.Server;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.Vector;

public class SocketProxyAgent
extends Agent {
    protected static final int DEFAULT_PORT = 6789;
    PrintStream logFile;
    BufferedReader in;
    Server proxyServer;

    protected void setup() {
        try {
            this.logFile = new PrintStream(new FileOutputStream(this.getLocalName() + ".log", true));
            this.log("----------------  Startup " + new GregorianCalendar().getTime() + "  ----------------");
            this.log("My agent name:" + this.getLocalName());
            this.log("Opening configuration file:\"" + this.getLocalName() + ".inf\"");
            int n = 6789;
            Vector<String> vector = new Vector<String>();
            try {
                this.in = new BufferedReader(new FileReader(this.getLocalName() + ".inf"));
                n = Integer.parseInt(this.in.readLine());
                StringTokenizer stringTokenizer = new StringTokenizer(this.in.readLine());
                while (stringTokenizer.hasMoreTokens()) {
                    int n2;
                    String string = stringTokenizer.nextToken();
                    if (!string.equals("*") && (n2 = string.lastIndexOf(64)) == -1) {
                        string = string + "@" + this.getHap();
                    }
                    this.log("Legal addressee:" + string);
                    vector.add(string);
                }
            }
            catch (Exception exception) {
                this.log("Unable to read file " + this.getLocalName() + ".inf, so will use default settings.");
                n = 6789;
                vector.add("*");
            }
            this.log("Attempting to open a server socket on port: " + n);
            this.proxyServer = new Server(n, this, vector);
        }
        catch (Exception exception) {
            this.log("Failed to start server socket" + exception);
            exception.printStackTrace();
            this.doDelete();
        }
    }

    protected void takeDown() {
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.logFile != null) {
                this.logFile.close();
                this.logFile = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.proxyServer != null) {
                this.proxyServer.closeDown();
                this.proxyServer.join(1000L);
                this.proxyServer = null;
            }
        }
        catch (Exception exception) {}
    }

    public synchronized void log(String string) {
        this.logFile.println(string);
        this.logFile.flush();
    }
}

