/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.applet;

import jade.content.Concept;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Deregister;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.Modify;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.UnsupportedFunction;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.tools.applet.AppletRequestProto;
import jade.tools.applet.DFAppletCommunicator;
import jade.tools.dfgui.DFGUI;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.Date;

public class FIPAAppletRequestProto
extends AppletRequestProto {
    Codec c;
    String action;
    Object dfd;
    private static Ontology o = FIPAManagementOntology.getInstance();
    AID receiver;
    DFGUI gui;
    DFAppletCommunicator dfApplet;
    ACLMessage lastMsg;

    FIPAAppletRequestProto(DFAppletCommunicator dFAppletCommunicator, AID aID, String string, Object object, SearchConstraints searchConstraints) throws FIPAException {
        super(dFAppletCommunicator.getStream(), dFAppletCommunicator.getParser(), new ACLMessage(16));
        this.gui = dFAppletCommunicator.getGUI();
        this.dfApplet = dFAppletCommunicator;
        this.reqMsg = new ACLMessage(16);
        this.reqMsg.addReceiver(aID);
        this.reqMsg.setProtocol("fipa-request");
        this.reqMsg.setLanguage("fipa-sl");
        this.reqMsg.setOntology("FIPA-Agent-Management");
        this.reqMsg.setReplyWith("rw" + new Date().getTime());
        this.reqMsg.setConversationId("conv" + new Date().getTime());
        this.action = string;
        this.dfd = object;
        this.receiver = aID;
        Action action = new Action();
        action.setActor(aID);
        if (string.equalsIgnoreCase("register")) {
            Register register = new Register();
            register.setDescription(object);
            action.setAction((Concept)register);
        } else if (string.equalsIgnoreCase("deregister")) {
            Deregister deregister = new Deregister();
            deregister.setDescription(object);
            action.setAction((Concept)deregister);
        } else if (string.equalsIgnoreCase("modify")) {
            Modify modify = new Modify();
            modify.setDescription(object);
            action.setAction((Concept)modify);
        } else if (string.equalsIgnoreCase("search")) {
            Search search = new Search();
            search.setDescription(object);
            search.setConstraints(searchConstraints);
            action.setAction((Concept)search);
        } else {
            throw new UnsupportedFunction();
        }
        this.c = new SLCodec();
        this.reqMsg.setContent(AppletRequestProto.encode(action, (SLCodec)this.c, o));
    }

    public List getSearchResult() throws FIPAException, NotYetReady {
        if (this.notYetReady) {
            throw new NotYetReady();
        }
        if (this.lastMsg.getPerformative() != 7) {
            throw new FIPAException(this.lastMsg);
        }
        Result result = AppletRequestProto.extractContent(this.lastMsg.getContent(), (SLCodec)this.c, o);
        Iterator iterator = result.getItems().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public void handleInform(ACLMessage aCLMessage) {
        block12: {
            this.notYetReady = false;
            this.lastMsg = (ACLMessage)aCLMessage.clone();
            try {
                if (this.action.equalsIgnoreCase("register")) {
                    if (this.dfApplet.isADF((DFAgentDescription)this.dfd)) {
                        this.gui.addChildren(((DFAgentDescription)this.dfd).getName());
                    }
                    this.gui.addAgentDesc(((DFAgentDescription)this.dfd).getName());
                    this.gui.showStatusMsg("Registration of agent:" + ((DFAgentDescription)this.dfd).getName().getName() + " done.");
                    break block12;
                }
                if (this.action.equalsIgnoreCase("search")) {
                    try {
                        this.gui.showStatusMsg("Search request Processed. Ready for new request.");
                        this.gui.refreshLastSearchResults(this.getSearchResult(), aCLMessage.getSender());
                    }
                    catch (NotYetReady notYetReady) {
                    }
                    catch (FIPAException fIPAException) {}
                    break block12;
                }
                if (this.action.equalsIgnoreCase("deregister")) {
                    try {
                        this.gui.removeChildren(((DFAgentDescription)this.dfd).getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.gui.removeAgentDesc(((DFAgentDescription)this.dfd).getName(), this.dfApplet.getDescriptionOfThisDF().getName());
                    this.gui.showStatusMsg("Deregistration of agent: " + ((DFAgentDescription)this.dfd).getName().getName() + " done.");
                    break block12;
                }
                if (this.action.equalsIgnoreCase("modify")) {
                    this.gui.removeAgentDesc(((DFAgentDescription)this.dfd).getName(), this.dfApplet.getDescriptionOfThisDF().getName());
                    this.gui.addAgentDesc(((DFAgentDescription)this.dfd).getName());
                    this.gui.showStatusMsg("Modify of Agent: " + ((DFAgentDescription)this.dfd).getName().getName() + " done.");
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    protected void handleAgree(ACLMessage aCLMessage) {
        try {
            this.gui.showStatusMsg("Process your request & waiting for result..");
        }
        catch (NullPointerException nullPointerException) {}
    }

    protected void handleNotUnderstood(ACLMessage aCLMessage) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)aCLMessage.clone();
    }

    protected void handleOtherMessage(ACLMessage aCLMessage) {
    }

    protected void handleRefuse(ACLMessage aCLMessage) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)aCLMessage.clone();
    }

    protected void handleFailure(ACLMessage aCLMessage) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)aCLMessage.clone();
    }

    public static class NotYetReady
    extends Exception {
        NotYetReady() {
            super("Requested message is not ready yet.");
        }
    }
}

