/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.core.AID;
import jade.core.Agent;
import jade.lang.acl.ACLMessage;
import jade.tools.gui.ACLAIDDialog;
import jade.util.leap.Iterator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ACLAIDList
extends JPanel {
    private String MSG = "msg";
    private String AID = "Aid";
    private JScrollPane contentScrollPane = new JScrollPane();
    private JList contentList = new JList();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JButton viewButton = new JButton();
    private JButton addButton = new JButton();
    private JButton deleteButton = new JButton();
    private DefaultListModel listModel = new DefaultListModel();
    private AIDListCellRenderer aidListCellRenderer = new AIDListCellRenderer();
    private boolean editable = true;
    private String fieldName = "";
    private String mode = this.MSG;
    private Agent agent;
    private AIDListListener theDataListener;
    private ACLMessage itsMsg;
    private AID itsAid;
    private Object itsObj;

    public ACLAIDList(Agent agent) {
        this.agent = agent;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setEditable(boolean bl) {
        if (!bl) {
            this.editable = false;
            this.addButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    public void register(Object object, String string) {
        this.listModel.removeAllElements();
        this.itsObj = object;
        this.mode = this.MSG;
        this.fieldName = string;
        String string2 = "getAll" + string;
        try {
            Method method = this.itsObj.getClass().getMethod(string2, null);
            Iterator iterator = (Iterator)method.invoke(this.itsObj, new Object[0]);
            while (iterator.hasNext()) {
                AID aID = (AID)iterator.next();
                this.listModel.addElement(aID);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.theDataListener = new AIDListListener();
        this.theDataListener.register(this.itsObj, string);
        this.listModel.addListDataListener(this.theDataListener);
        this.contentList.setModel(this.listModel);
    }

    public void register(AID aID, String string) {
        this.itsAid = aID;
        this.mode = this.AID;
        this.fieldName = string;
        String string2 = "getAll" + string;
        try {
            Method method = aID.getClass().getMethod(string2, null);
            Iterator iterator = (Iterator)method.invoke((Object)aID, new Object[0]);
            while (iterator.hasNext()) {
                AID aID2 = (AID)iterator.next();
                this.listModel.addElement(aID2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.theDataListener = new AIDListListener();
        this.theDataListener.register(aID, string);
        this.listModel.addListDataListener(this.theDataListener);
        this.contentList.setModel(this.listModel);
    }

    void doView() {
        int n = this.contentList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        AID aID = (AID)this.listModel.getElementAt(n);
        AID aID2 = (AID)aID.clone();
        ACLAIDDialog aCLAIDDialog = new ACLAIDDialog(this.agent);
        aCLAIDDialog.setLocation((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY());
        aCLAIDDialog.setItsAID(aID2);
        aCLAIDDialog.setEditable(this.editable);
        aCLAIDDialog.setTitle(this.editable ? "Edit AID of: " + aID.getName() : "View AID of:" + aID.getName());
        aCLAIDDialog.show();
        if (aCLAIDDialog.getOK()) {
            this.theDataListener.registerChangedAID(aCLAIDDialog.getItsAID());
            this.listModel.setElementAt(aID2, n);
        }
    }

    void deleteButton_actionPerformed(ActionEvent actionEvent) {
        this.doDelete();
    }

    void doDelete() {
        int n = this.contentList.getSelectedIndex();
        if (n >= 0) {
            this.theDataListener.registerRemovedAID((AID)this.listModel.getElementAt(n));
            this.listModel.remove(n);
        }
    }

    void addButton_actionPerformed(ActionEvent actionEvent) {
        this.doAdd();
    }

    void doAdd() {
        ACLAIDDialog aCLAIDDialog = new ACLAIDDialog(this.agent);
        aCLAIDDialog.setTitle("<new AID>");
        aCLAIDDialog.setLocation((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY());
        aCLAIDDialog.localCheckBox.setSelected(false);
        aCLAIDDialog.show();
        if (aCLAIDDialog.getOK()) {
            this.listModel.addElement(aCLAIDDialog.getItsAID());
        }
    }

    void viewButton_actionPerformed(ActionEvent actionEvent) {
        this.doView();
    }

    void contentList_mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.doView();
        }
    }

    void contentList_keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.doView();
        }
        if (!this.editable) {
            return;
        }
        if (keyEvent.getKeyCode() == 155) {
            this.doAdd();
        }
        if (keyEvent.getKeyCode() == 127) {
            this.doDelete();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.viewButton.setBackground(Color.white);
        this.viewButton.setFont(new Font("Dialog", 0, 11));
        this.viewButton.setForeground(new Color(0, 0, 83));
        this.viewButton.setMinimumSize(new Dimension(13, 5));
        this.viewButton.setPreferredSize(new Dimension(13, 11));
        this.viewButton.setToolTipText("edit/view AgentIDentifier (AID)");
        this.viewButton.setMargin(new Insets(0, 0, 0, 0));
        this.viewButton.setText("v");
        this.viewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLAIDList.this.viewButton_actionPerformed(actionEvent);
            }
        });
        this.addButton.setBackground(Color.white);
        this.addButton.setFont(new Font("Dialog", 0, 11));
        this.addButton.setForeground(new Color(0, 0, 83));
        this.addButton.setMinimumSize(new Dimension(13, 5));
        this.addButton.setPreferredSize(new Dimension(13, 11));
        this.addButton.setToolTipText("add AgentIDentifier (AID)");
        this.addButton.setMargin(new Insets(0, 0, 0, 0));
        this.addButton.setText("+");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLAIDList.this.addButton_actionPerformed(actionEvent);
            }
        });
        this.deleteButton.setBackground(Color.white);
        this.deleteButton.setFont(new Font("Dialog", 0, 11));
        this.deleteButton.setForeground(new Color(0, 0, 83));
        this.deleteButton.setMinimumSize(new Dimension(13, 5));
        this.deleteButton.setPreferredSize(new Dimension(13, 11));
        this.deleteButton.setToolTipText("delete AgentIDentifier (AID)");
        this.deleteButton.setMargin(new Insets(0, 0, 0, 0));
        this.deleteButton.setText("x");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ACLAIDList.this.deleteButton_actionPerformed(actionEvent);
            }
        });
        this.contentList.setCellRenderer(this.aidListCellRenderer);
        this.contentList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ACLAIDList.this.contentList_keyPressed(keyEvent);
            }
        });
        this.contentList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ACLAIDList.this.contentList_mouseClicked(mouseEvent);
            }
        });
        this.contentScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.add((Component)this.addButton, new GridBagConstraints(2, 1, 0, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.deleteButton, new GridBagConstraints(2, 2, 0, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.viewButton, new GridBagConstraints(2, 0, 0, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.contentScrollPane, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.contentScrollPane.getViewport().add((Component)this.contentList, null);
    }

    public class AIDListListener
    implements ListDataListener {
        String fieldName = "";
        private AID theRemovedAID;
        private AID theChangedAID;
        private Object itsObj;

        public void register(Object object, String string) {
            this.itsObj = object;
            this.fieldName = string;
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            DefaultListModel defaultListModel = (DefaultListModel)listDataEvent.getSource();
            int n = listDataEvent.getIndex0();
            AID aID = (AID)defaultListModel.elementAt(n);
            String string = "add" + this.fieldName;
            String string2 = "jade.core.AID";
            try {
                Method method = this.itsObj.getClass().getMethod(string, Class.forName(string2));
                AID aID2 = aID;
                method.invoke(this.itsObj, aID2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void registerRemovedAID(AID aID) {
            this.theRemovedAID = aID;
        }

        public void registerChangedAID(AID aID) {
            this.theChangedAID = aID;
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            String string = "remove" + this.fieldName;
            String string2 = "jade.core.AID";
            try {
                Method method = this.itsObj.getClass().getMethod(string, Class.forName(string2));
                AID aID = this.theRemovedAID;
                method.invoke(this.itsObj, aID);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            DefaultListModel defaultListModel = (DefaultListModel)listDataEvent.getSource();
            int n = listDataEvent.getIndex0();
            if (n < 0) {
                return;
            }
            String string = "remove" + this.fieldName;
            String string2 = "remove" + this.fieldName;
            AID aID = (AID)defaultListModel.get(n);
            String string3 = "jade.core.AID";
            try {
                Method method = this.itsObj.getClass().getMethod(string, Class.forName(string3));
                method.invoke(this.itsObj, aID);
                Method method2 = this.itsObj.getClass().getMethod(string2, Class.forName(string3));
                method.invoke(this.itsObj, this.theChangedAID);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public class AIDListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public AIDListCellRenderer() {
            this.setOpaque(true);
            this.setFont(new Font("Dialog", 0, 11));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null && object instanceof AID) {
                AID aID = (AID)object;
                this.setText(aID.getName());
            }
            this.setBackground(bl ? Color.blue : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

