/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.lang.acl.ACLMessage;
import jade.tools.gui.ACLPerformativesRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.UIManager;

public class ACLComboBox
extends JComboBox
implements Observer {
    private static String[] fipaProtocols = new String[]{"", "fipa-request", "fipa-query", "fipa-request-when", "fipa-auction-english", "fipa-auction-dutch", "fipa-brokering", "fipa-recruiting", "fipa-propose", "fipa-contract-net", "fipa-iterated-contract-net"};
    private DefaultComboBoxModel comboBoxModel = new DefaultComboBoxModel();
    private ACLMessage msg;
    private String fieldName;

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.setEnabled(bl);
    }

    public void registerPerformatives(Object object) {
        this.comboBoxModel.removeAllElements();
        String[] stringArray = ACLMessage.getAllPerformativeNames();
        int n = 0;
        while (n < stringArray.length) {
            this.comboBoxModel.addElement(stringArray[n]);
            ++n;
        }
        this.setModel(this.comboBoxModel);
        this.setRenderer(new ACLPerformativesRenderer());
        this.msg = (ACLMessage)object;
        this.setSelectedIndex(this.msg.getPerformative());
        this.fieldName = this.fieldName;
        String string = "get" + this.fieldName;
        String string2 = "java.lang.String";
        this.setBackground(Color.white);
        this.setFont(new Font("Dialog", 1, 11));
        Color color = ACLPerformativesRenderer.determineColor(ACLMessage.getPerformative((int)this.msg.getPerformative()));
        this.setForeground(color);
        UIManager.put("ComboBox.disabledForeground", color);
        UIManager.put("ComboBox.disabledBackground", Color.white);
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ACLComboBox.this.performativeItemStateChanged();
            }
        });
        this.repaint();
        this.updateUI();
    }

    public void registerProtocol(Object object) {
        this.comboBoxModel.removeAllElements();
        int n = 0;
        while (n < fipaProtocols.length) {
            this.comboBoxModel.addElement(fipaProtocols[n]);
            ++n;
        }
        this.setModel(this.comboBoxModel);
        this.msg = (ACLMessage)object;
        this.setSelectedItem(this.msg.getProtocol());
        this.fieldName = this.fieldName;
        String string = "get" + this.fieldName;
        String string2 = "java.lang.String";
        this.setBackground(Color.white);
        UIManager.put("ComboBox.disabledForeground", Color.black);
        UIManager.put("ComboBox.disabledBackground", Color.white);
        this.setFont(new Font("Dialog", 0, 11));
        this.setEditable(true);
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ACLComboBox.this.protocolItemStateChanged();
            }
        });
        this.repaint();
        this.updateUI();
    }

    public void update(Observable observable, Object object) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    void performativeItemStateChanged() {
        if (this.getSelectedItem() == null) {
            return;
        }
        String string = (String)this.getSelectedItem();
        this.setForeground(ACLPerformativesRenderer.determineColor(string));
        if (this.isEnabled()) {
            int n = this.getSelectedIndex();
            this.msg.setPerformative(n);
        }
    }

    void protocolItemStateChanged() {
        if (this.getSelectedItem() == null) {
            return;
        }
        if (this.isEnabled()) {
            String string = (String)this.getSelectedItem();
            this.msg.setProtocol(string);
        }
    }
}

