/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.tools.gui.ACLSyntaxUtilities;
import jade.tools.gui.ACLToken;
import javax.swing.text.Segment;

public class ACLSLTokenMarker {
    public static final byte S_ONE = 100;
    public static final byte S_TWO = 101;
    public static final byte S_END = 102;
    private static KeywordMap aclSLKeywords;
    protected ACLToken firstToken;
    protected ACLToken lastToken;
    protected LineInfo[] lineInfo;
    protected int length;
    protected int lastLine = -1;
    protected boolean nextLineRequested;
    private KeywordMap keywords;
    private byte token;
    private int lastOffset;
    private int lastKeyword;
    private char matchChar;
    private boolean matchCharBracket;
    private boolean matchSpacesAllowed;

    public ACLSLTokenMarker() {
        this(ACLSLTokenMarker.getKeywords());
        this.lastLine = -1;
    }

    public ACLSLTokenMarker(KeywordMap keywordMap) {
        this.keywords = keywordMap;
    }

    private static KeywordMap getKeywords() {
        if (aclSLKeywords == null) {
            aclSLKeywords = new KeywordMap(false);
            aclSLKeywords.add("inv", (byte)10);
            aclSLKeywords.add("ams", (byte)5);
            aclSLKeywords.add("df", (byte)5);
            aclSLKeywords.add("rma", (byte)5);
            aclSLKeywords.add("l1", (byte)3);
            aclSLKeywords.add("l2", (byte)4);
            aclSLKeywords.add("wantarray", (byte)8);
            aclSLKeywords.add("warn", (byte)8);
            aclSLKeywords.add("write", (byte)8);
            aclSLKeywords.add("m", (byte)100);
            aclSLKeywords.add("q", (byte)100);
            aclSLKeywords.add("qq", (byte)100);
            aclSLKeywords.add("qw", (byte)100);
            aclSLKeywords.add("qx", (byte)100);
            aclSLKeywords.add("s", (byte)101);
            aclSLKeywords.add("tr", (byte)101);
            aclSLKeywords.add("y", (byte)101);
        }
        return aclSLKeywords;
    }

    public boolean isNextLineRequested() {
        return this.nextLineRequested;
    }

    public ACLToken markTokens(Segment segment, int n) {
        byte by;
        if (n >= this.length) {
            throw new IllegalArgumentException("Tokenizing invalid line: " + n);
        }
        this.lastToken = null;
        LineInfo lineInfo = this.lineInfo[n];
        LineInfo lineInfo2 = n == 0 ? null : this.lineInfo[n - 1];
        byte by2 = lineInfo.token;
        lineInfo.token = by = this.markTokensImpl(lineInfo2 == null ? (byte)0 : lineInfo2.token, segment, n);
        if (this.lastLine != n || !this.nextLineRequested) {
            this.nextLineRequested = by2 != by;
        }
        this.lastLine = n;
        this.addToken(0, (byte)127);
        return this.firstToken;
    }

    public boolean supportsMultilineTokens() {
        return true;
    }

    public void insertLines(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        this.length += n2;
        this.ensureCapacity(this.length);
        int n3 = n + n2;
        System.arraycopy(this.lineInfo, n, this.lineInfo, n3, this.lineInfo.length - n3);
        int n4 = n + n2 - 1;
        while (n4 >= n) {
            this.lineInfo[n4] = new LineInfo();
            --n4;
        }
    }

    public void deleteLines(int n, int n2) {
        if (n2 <= 0) {
            return;
        }
        int n3 = n + n2;
        this.length -= n2;
        System.arraycopy(this.lineInfo, n3, this.lineInfo, n, this.lineInfo.length - n3);
    }

    public byte markTokensImpl(byte by, Segment segment, int n) {
        char[] cArray = segment.array;
        int n2 = segment.offset;
        this.token = by;
        this.lastOffset = n2;
        this.lastKeyword = n2;
        this.matchChar = '\u0000';
        this.matchCharBracket = false;
        this.matchSpacesAllowed = false;
        int n3 = segment.count + n2;
        if (this.token == 3 && n != 0 && this.lineInfo[n - 1].obj != null) {
            String string = (String)this.lineInfo[n - 1].obj;
            if (string != null && string.length() == segment.count && ACLSyntaxUtilities.regionMatches(false, segment, n2, string)) {
                this.addToken(segment.count, this.token);
                return 0;
            }
            this.addToken(segment.count, this.token);
            this.lineInfo[n].obj = string;
            return this.token;
        }
        boolean bl = false;
        int n4 = n2;
        block33: while (n4 < n3) {
            int n5 = n4 + 1;
            char c = cArray[n4];
            if (c == '\\') {
                bl = !bl;
            } else {
                block0 : switch (this.token) {
                    case 0: {
                        switch (c) {
                            case '#': {
                                if (bl) {
                                    bl = false;
                                    break;
                                }
                                if (this.doKeyword(segment, n4, c)) break block0;
                                this.addToken(n4 - this.lastOffset, this.token);
                                this.addToken(n3 - n4, (byte)1);
                                this.lastOffset = this.lastKeyword = n3;
                                break block33;
                            }
                            case '.': 
                            case '@': {
                                bl = false;
                                if (n3 - n4 <= 1) break block0;
                                if (this.doKeyword(segment, n4, c)) break block0;
                                this.addToken(n4 - this.lastOffset, this.token);
                                this.lastOffset = this.lastKeyword = n4;
                                this.token = (byte)7;
                                break;
                            }
                            case '=': {
                                bl = false;
                                if (n4 == n2) {
                                    this.token = (byte)2;
                                    this.addToken(n3 - n4, this.token);
                                    this.lastOffset = this.lastKeyword = n3;
                                    break block33;
                                }
                                this.doKeyword(segment, n4, c);
                                break;
                            }
                            case '$': 
                            case '%': 
                            case '&': {
                                bl = false;
                                if (n3 - n4 <= 1) break block0;
                                if (this.doKeyword(segment, n4, c)) break block0;
                                if (c == '&' && (cArray[n5] == '&' || Character.isWhitespace(cArray[n5]))) {
                                    ++n4;
                                    break;
                                }
                                this.addToken(n4 - this.lastOffset, this.token);
                                this.lastOffset = this.lastKeyword = n4;
                                this.token = (byte)7;
                                break;
                            }
                            case '\"': {
                                if (bl) {
                                    bl = false;
                                    break;
                                }
                                if (this.doKeyword(segment, n4, c)) break block0;
                                this.addToken(n4 - this.lastOffset, this.token);
                                this.token = (byte)3;
                                this.lineInfo[n].obj = null;
                                this.lastOffset = this.lastKeyword = n4;
                                break;
                            }
                            case '\'': {
                                if (bl) {
                                    bl = false;
                                    break;
                                }
                                int n6 = this.lastKeyword;
                                if (this.doKeyword(segment, n4, c) || n4 != n6) break block0;
                                this.addToken(n4 - this.lastOffset, this.token);
                                this.token = (byte)4;
                                this.lastOffset = this.lastKeyword = n4;
                                break;
                            }
                            case '`': {
                                if (bl) {
                                    bl = false;
                                    break;
                                }
                                if (this.doKeyword(segment, n4, c)) break block0;
                                this.addToken(n4 - this.lastOffset, this.token);
                                this.token = (byte)9;
                                this.lastOffset = this.lastKeyword = n4;
                                break;
                            }
                            case '<': {
                                if (bl) {
                                    bl = false;
                                    break;
                                }
                                if (this.doKeyword(segment, n4, c)) break block0;
                                if (n3 - n4 <= 2 || cArray[n5] != '<' || Character.isWhitespace(cArray[n4 + 2])) break block0;
                                this.addToken(n4 - this.lastOffset, this.token);
                                this.lastOffset = this.lastKeyword = n4;
                                this.token = (byte)3;
                                int n6 = n3 - (n4 + 2);
                                if (cArray[n3 - 1] == ';') {
                                    --n6;
                                }
                                this.lineInfo[n].obj = new String(cArray, n4 + 2, n6);
                                break;
                            }
                            case '?': {
                                if (n4 != this.lastKeyword || n3 - n4 <= 1) break block0;
                                if (this.doKeyword(segment, n4, c)) break block0;
                                bl = false;
                                int n6 = cArray[n5];
                                if (Character.isWhitespace((char)n6)) break block0;
                                this.matchChar = c;
                                this.matchSpacesAllowed = false;
                                this.addToken(n4 - this.lastOffset, this.token);
                                this.token = (byte)100;
                                this.lastOffset = this.lastKeyword = n4;
                                break;
                            }
                            default: {
                                bl = false;
                                if (Character.isLetterOrDigit(c) || c == '_' || c == '-') break block0;
                                this.doKeyword(segment, n4, c);
                                break;
                            }
                        }
                        break;
                    }
                    case 7: {
                        bl = false;
                        if (Character.isLetterOrDigit(c) || c == '_' || c == '#' || c == '\'' || c == '-' || c == '.') break;
                        if (n4 != n2 && cArray[n4 - 1] == '$') {
                            this.addToken(n5 - this.lastOffset, this.token);
                            this.lastOffset = this.lastKeyword = n5;
                            break;
                        }
                        this.addToken(n4 - this.lastOffset, this.token);
                        this.lastOffset = this.lastKeyword = n4;
                        this.token = 0;
                        break;
                    }
                    case 100: 
                    case 101: {
                        if (bl) {
                            bl = false;
                            break;
                        }
                        if (this.matchChar == '\u0000') {
                            if (Character.isWhitespace(this.matchChar) && !this.matchSpacesAllowed) break;
                            this.matchChar = c;
                            break;
                        }
                        switch (this.matchChar) {
                            case '(': {
                                this.matchChar = (char)41;
                                this.matchCharBracket = true;
                                break;
                            }
                            case '[': {
                                this.matchChar = (char)93;
                                this.matchCharBracket = true;
                                break;
                            }
                            case '{': {
                                this.matchChar = (char)125;
                                this.matchCharBracket = true;
                                break;
                            }
                            case '<': {
                                this.matchChar = (char)62;
                                this.matchCharBracket = true;
                                break;
                            }
                            default: {
                                this.matchCharBracket = false;
                            }
                        }
                        if (c != this.matchChar) break;
                        if (this.token == 101) {
                            this.token = (byte)100;
                            if (!this.matchCharBracket) break;
                            this.matchChar = '\u0000';
                            break;
                        }
                        this.token = (byte)102;
                        this.addToken(n5 - this.lastOffset, (byte)4);
                        this.lastOffset = this.lastKeyword = n5;
                        break;
                    }
                    case 102: {
                        bl = false;
                        if (Character.isLetterOrDigit(c) || c == '_' || c == '-') break;
                        this.doKeyword(segment, n4, c);
                        break;
                    }
                    case 2: {
                        bl = false;
                        if (n4 != n2) break;
                        this.addToken(segment.count, this.token);
                        if (n3 - n4 > 3 && ACLSyntaxUtilities.regionMatches(false, segment, n2, "=cut")) {
                            this.token = 0;
                        }
                        this.lastOffset = this.lastKeyword = n3;
                        break block33;
                    }
                    case 3: {
                        if (bl) {
                            bl = false;
                            break;
                        }
                        if (c == '$') {
                            bl = true;
                            break;
                        }
                        if (c != '\"') break;
                        this.addToken(n5 - this.lastOffset, this.token);
                        this.token = 0;
                        this.lastOffset = this.lastKeyword = n5;
                        break;
                    }
                    case 4: {
                        if (bl) {
                            bl = false;
                            break;
                        }
                        if (c == '$') {
                            bl = true;
                            break;
                        }
                        if (c != '\'') break;
                        this.addToken(n5 - this.lastOffset, (byte)3);
                        this.token = 0;
                        this.lastOffset = this.lastKeyword = n5;
                        break;
                    }
                    case 9: {
                        if (bl) {
                            bl = false;
                            break;
                        }
                        if (c != '`') break;
                        this.addToken(n5 - this.lastOffset, this.token);
                        this.token = 0;
                        this.lastOffset = this.lastKeyword = n5;
                        break;
                    }
                    default: {
                        throw new InternalError("Invalid state: " + this.token);
                    }
                }
            }
            ++n4;
        }
        if (this.token == 0) {
            this.doKeyword(segment, n3, '\u0000');
        }
        switch (this.token) {
            case 0: {
                this.addToken(n3 - this.lastOffset, this.token);
                break;
            }
            case 7: {
                this.addToken(n3 - this.lastOffset, this.token);
                this.token = 0;
                break;
            }
            case 102: {
                this.addToken(n3 - this.lastOffset, (byte)4);
                this.token = 0;
                break;
            }
            case 100: 
            case 101: {
                this.addToken(n3 - this.lastOffset, (byte)10);
                this.token = 0;
                break;
            }
            default: {
                this.addToken(n3 - this.lastOffset, this.token);
            }
        }
        return this.token;
    }

    protected void ensureCapacity(int n) {
        if (this.lineInfo == null) {
            this.lineInfo = new LineInfo[n + 1];
        } else if (this.lineInfo.length <= n) {
            LineInfo[] lineInfoArray = new LineInfo[(n + 1) * 2];
            System.arraycopy(this.lineInfo, 0, lineInfoArray, 0, this.lineInfo.length);
            this.lineInfo = lineInfoArray;
        }
    }

    protected void addToken(int n, byte by) {
        if (by >= 100 && by <= 126) {
            throw new InternalError("Invalid id: " + by);
        }
        if (n == 0 && by != 127) {
            return;
        }
        if (this.firstToken == null) {
            this.lastToken = this.firstToken = new ACLToken(n, by);
        } else if (this.lastToken == null) {
            this.lastToken = this.firstToken;
            this.firstToken.length = n;
            this.firstToken.id = by;
        } else if (this.lastToken.next == null) {
            this.lastToken = this.lastToken.next = new ACLToken(n, by);
        } else {
            this.lastToken = this.lastToken.next;
            this.lastToken.length = n;
            this.lastToken.id = by;
        }
    }

    private boolean doKeyword(Segment segment, int n, char c) {
        int n2 = n + 1;
        if (this.token == 102) {
            this.addToken(n - this.lastOffset, (byte)4);
            this.token = 0;
            this.lastOffset = n;
            this.lastKeyword = n2;
            return false;
        }
        int n3 = n - this.lastKeyword;
        byte by = this.keywords.lookup(segment, this.lastKeyword, n3);
        if (by == 100 || by == 101) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n3, (byte)4);
            this.lastOffset = n;
            this.lastKeyword = n2;
            this.matchChar = Character.isWhitespace(c) ? (char)'\u0000' : c;
            this.matchSpacesAllowed = true;
            this.token = by;
            return true;
        }
        if (by != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n3, by);
            this.lastOffset = n;
        }
        this.lastKeyword = n2;
        return false;
    }

    public class LineInfo {
        public byte token;
        public Object obj;

        public LineInfo() {
        }

        public LineInfo(byte by, Object object) {
            this.token = by;
            this.obj = object;
        }
    }

    private static class KeywordMap {
        protected int mapLength;
        private Keyword[] map;
        private boolean ignoreCase;

        public KeywordMap(boolean bl) {
            this(bl, 52);
            this.ignoreCase = bl;
        }

        public KeywordMap(boolean bl, int n) {
            this.mapLength = n;
            this.ignoreCase = bl;
            this.map = new Keyword[n];
        }

        public boolean getIgnoreCase() {
            return this.ignoreCase;
        }

        public void setIgnoreCase(boolean bl) {
            this.ignoreCase = bl;
        }

        public byte lookup(Segment segment, int n, int n2) {
            if (n2 == 0) {
                return 0;
            }
            Keyword keyword = this.map[this.getSegmentMapKey(segment, n, n2)];
            while (keyword != null) {
                if (n2 != keyword.keyword.length) {
                    keyword = keyword.next;
                    continue;
                }
                if (ACLSyntaxUtilities.regionMatches(this.ignoreCase, segment, n, keyword.keyword)) {
                    return keyword.id;
                }
                keyword = keyword.next;
            }
            return 0;
        }

        public void add(String string, byte by) {
            int n = this.getStringMapKey(string);
            this.map[n] = new Keyword(string.toCharArray(), by, this.map[n]);
        }

        protected int getStringMapKey(String string) {
            return (Character.toUpperCase(string.charAt(0)) + Character.toUpperCase(string.charAt(string.length() - 1))) % this.mapLength;
        }

        protected int getSegmentMapKey(Segment segment, int n, int n2) {
            return (Character.toUpperCase(segment.array[n]) + Character.toUpperCase(segment.array[n + n2 - 1])) % this.mapLength;
        }

        class Keyword {
            public char[] keyword;
            public byte id;
            public Keyword next;

            public Keyword(char[] cArray, byte by, Keyword keyword) {
                this.keyword = cArray;
                this.id = by;
                this.next = keyword;
            }
        }
    }
}

