/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.introspector.gui;

import jade.tools.introspector.gui.BehaviourTreeNode;
import jade.tools.introspector.gui.GuiProperties;
import jade.tools.introspector.gui.TreeMouseListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class BehaviourPanel
extends JSplitPane {
    private JTree behaviourTree;
    private JTextArea text;
    private JScrollPane behaviourScroll;
    private JScrollPane textScroll;
    private JPanel treePanel;
    private TreeMouseListener treeListener;
    private Icon readyIcon;
    private Icon runningIcon;
    private Icon blockedIcon;

    public BehaviourPanel(DefaultTreeModel defaultTreeModel) {
        this.behaviourTree = new JTree(defaultTreeModel);
        this.treeListener = new TreeMouseListener(this);
        this.behaviourTree.addMouseListener(this.treeListener);
        this.behaviourTree.setCellRenderer(new BehaviourCellRenderer());
        this.build();
    }

    public void build() {
        this.text = new JTextArea();
        this.behaviourScroll = new JScrollPane();
        this.textScroll = new JScrollPane();
        this.treePanel = new JPanel();
        this.treePanel.setLayout(new BorderLayout());
        this.readyIcon = GuiProperties.getIcon("Introspector.readyIcon");
        this.blockedIcon = GuiProperties.getIcon("Introspector.blockedIcon");
        this.runningIcon = GuiProperties.getIcon("Introspector.runningIcon");
        this.behaviourTree.putClientProperty("JTree.lineStyle", "Angled");
        this.behaviourTree.setShowsRootHandles(true);
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.behaviourTree.getCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(this.readyIcon);
        defaultTreeCellRenderer.setOpenIcon(this.readyIcon);
        defaultTreeCellRenderer.setClosedIcon(this.readyIcon);
        this.treePanel.add((Component)this.behaviourTree, "Center");
        this.behaviourScroll.getViewport().add((Component)this.treePanel, null);
        this.textScroll.getViewport().add((Component)this.text, null);
        this.add((Component)this.behaviourScroll, "left");
        this.add((Component)this.textScroll, "right");
        this.setContinuousLayout(true);
        this.setDividerLocation(200);
    }

    public JTree getBehaviourTree() {
        return this.behaviourTree;
    }

    public JTextArea getBehaviourText() {
        return this.text;
    }

    class BehaviourCellRenderer
    extends DefaultTreeCellRenderer {
        BehaviourCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            block4: {
                try {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                    BehaviourTreeNode behaviourTreeNode = (BehaviourTreeNode)defaultMutableTreeNode.getUserObject();
                    String string = behaviourTreeNode.getState();
                    if (string.equals("BLOCKED")) {
                        this.changeIcon(BehaviourPanel.this.blockedIcon);
                        break block4;
                    }
                    if (string.equals("RUNNING")) {
                        this.changeIcon(BehaviourPanel.this.runningIcon);
                        break block4;
                    }
                    this.changeIcon(BehaviourPanel.this.readyIcon);
                }
                catch (Exception exception) {
                    this.setLeafIcon(this.getDefaultLeafIcon());
                    this.setOpenIcon(this.getDefaultOpenIcon());
                    this.setClosedIcon(this.getDefaultClosedIcon());
                }
            }
            return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }

        private void changeIcon(Icon icon) {
            this.setOpenIcon(icon);
            this.setLeafIcon(icon);
            this.setClosedIcon(icon);
        }
    }
}

