/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.logging;

import jade.core.AID;
import jade.gui.JadeLogoButton;
import jade.tools.logging.LogManagerAgent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LogManagerGui
extends JFrame {
    private LogManagerAgent myAgent;
    private Vector loggers = new Vector();
    private static final int WIDTH = 700;
    private static final int HEIGHT = 500;
    private static int NAME_COLUMN = 0;
    private static int SET_LEVEL_COLUMN = 1;
    private static int HANDLER_COLUMN = 2;
    private static int FILE_HANDLER_COLUMN = 3;
    private String logo = "images/logger.gif";
    private String jadeLogo = "images/jadelogo.jpg";
    private AID agentName;
    private static final String ErrorMessage = "A pattern consists of a string that includes the following special components that will be replaced at runtime:\n\n/        the local pathname separator\n%t     the system temporary directory \n%h    the value of the user.home system property \n%g    the generation number to distinguish rotated logs \n%u    a unique number to resolve conflicts \n%%    translates to a single percent sign %\n\nPlease refer to java.util.logging.FileHandler documentation for further informations.\n\n";
    private static final String ErrorPaneTitle = "Wrong  name for path specified ";
    LogManager logManager = LogManager.getLogManager();
    JComboBox levelCombo;

    public LogManagerGui(LogManagerAgent logManagerAgent) {
        this.myAgent = logManagerAgent;
        this.agentName = this.myAgent.getAID();
        this.init();
    }

    public void init() {
        this.setIconImage(this.getToolkit().getImage(this.getClass().getResource("/jade/gui/images/logosmall.jpg")));
        this.setTitle(this.myAgent.getLocalName() + " - Log Manager Agent");
        this.setSize(700, 500);
        LogTable logTable = new LogTable(this.getLoggers(), 4);
        JTable jTable = new JTable(logTable);
        this.getContentPane().add((Component)new JScrollPane(jTable), "Center");
        this.levelCombo = new JComboBox();
        this.levelCombo.addItem("SEVERE");
        this.levelCombo.addItem("WARNING");
        this.levelCombo.addItem("INFO");
        this.levelCombo.addItem("CONFIG");
        this.levelCombo.addItem("FINE");
        this.levelCombo.addItem("FINER");
        this.levelCombo.addItem("FINEST");
        this.levelCombo.addItem("ALL");
        this.levelCombo.addItem("OFF");
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(this.levelCombo);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(SET_LEVEL_COLUMN);
        tableColumn.setCellEditor(defaultCellEditor);
        try {
            this.setTitle(this.agentName.getName() + " - LogManagerAgent");
        }
        catch (Exception exception) {
            this.setTitle("LogManagerAgent");
        }
        Image image = this.getToolkit().getImage(this.getClass().getResource(this.logo));
        this.setIconImage(image);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("closing");
                LogManagerGui.this.dispose();
                LogManagerGui.this.myAgent.doDelete();
            }
        });
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(Box.createHorizontalGlue());
        JadeLogoButton jadeLogoButton = new JadeLogoButton();
        jToolBar.add(jadeLogoButton);
        this.getContentPane().add("North", jToolBar);
    }

    private int getLoggers() {
        Enumeration<String> enumeration = this.logManager.getLoggerNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            LogElem logElem = new LogElem(string, " ", " ");
            int n = 0;
            while (n < this.loggers.size() && ((LogElem)this.loggers.elementAt(n)).getLogger().toString().compareTo(string) <= 0) {
                ++n;
            }
            this.loggers.add(n, logElem);
        }
        return this.loggers.size();
    }

    public void showCorrect() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)dimension.getWidth() / 2;
        int n2 = (int)dimension.getHeight() / 2;
        this.setLocation(n - this.getWidth() / 2, n2 - this.getHeight() / 2);
        this.show();
    }

    class LogTable
    extends AbstractTableModel {
        private int rows;
        private int columns;
        private String logFile = null;

        public LogTable(int n, int n2) {
            this.rows = n;
            this.columns = n2;
        }

        public int getRowCount() {
            return this.rows;
        }

        public int getColumnCount() {
            return this.columns;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == SET_LEVEL_COLUMN || n2 == FILE_HANDLER_COLUMN;
        }

        public Object getValueAt(int n, int n2) {
            Object object;
            Object object2 = null;
            String string = null;
            Object var5_5 = null;
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            Logger logger = LogManagerGui.this.logManager.getLogger(LogManagerGui.this.logManager.getLogger(((LogElem)LogManagerGui.this.loggers.elementAt(n)).getLogger().toString()).getName());
            Level level = logger.getLevel();
            string = level != null ? level.getName() : LogManagerGui.this.logManager.getProperty(".level");
            String string4 = ((LogElem)LogManagerGui.this.loggers.elementAt(n)).getFileName();
            String string5 = string2 = LogManagerGui.this.logManager.getProperty("handlers");
            while (string5.indexOf(",") > 0) {
                object = string5.substring(0, string2.indexOf(","));
                string5 = string5.substring(string5.indexOf(",") + 1);
                if (!((String)object).equals("java.util.logging.FileHandler")) continue;
                bl = true;
            }
            if (string5.equals("java.util.logging.FileHandler")) {
                bl = true;
            }
            object = logger.getHandlers();
            int n3 = 0;
            while (n3 < ((Handler[])object).length) {
                string3 = object[n3].toString();
                if (!bl) {
                    string2 = string2 != null ? string2 + ", " + string3.substring(0, string3.indexOf("@")) : string3.substring(0, string3.indexOf("@"));
                }
                ++n3;
            }
            switch (n2) {
                case 0: {
                    object2 = ((LogElem)LogManagerGui.this.loggers.elementAt(n)).getLogger();
                    break;
                }
                case 1: {
                    object2 = string.toString();
                    break;
                }
                case 2: {
                    object2 = string2;
                    break;
                }
                case 3: {
                    object2 = string4;
                }
            }
            return object2;
        }

        public void setValueAt(Object object, int n, int n2) {
            Logger logger = LogManagerGui.this.logManager.getLogger(((LogElem)LogManagerGui.this.loggers.elementAt(n)).getLogger().toString());
            switch (n2) {
                case 1: {
                    Level level = Level.parse(object.toString());
                    logger.setLevel(level);
                    Handler[] handlerArray = logger.getParent().getHandlers();
                    Handler[] handlerArray2 = logger.getHandlers();
                    int n3 = 0;
                    while (n3 < handlerArray.length) {
                        handlerArray[n3].setLevel(level);
                        ++n3;
                    }
                    int n4 = 0;
                    while (n4 < handlerArray2.length) {
                        handlerArray2[n4].setLevel(level);
                        ++n4;
                    }
                    ((LogElem)LogManagerGui.this.loggers.elementAt(n)).setLevel(object.toString());
                    this.getValueAt(n, n2);
                    System.out.println("Set log level for " + logger.getName() + " to: " + logger.getLevel().toString());
                    break;
                }
                case 3: {
                    try {
                        ((LogElem)LogManagerGui.this.loggers.elementAt(n)).setFileName(object.toString());
                        if (((LogElem)LogManagerGui.this.loggers.elementAt(n)).getFileName().length() > 1) {
                            System.out.println(object.toString());
                            logger.addHandler(new FileHandler(object.toString()));
                        }
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(new JFrame(), LogManagerGui.ErrorMessage, LogManagerGui.ErrorPaneTitle, 0);
                    }
                    this.getValueAt(n, n2);
                }
            }
        }

        public String getColumnName(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = "Logger Name";
                    break;
                }
                case 1: {
                    string = "Set Level";
                    break;
                }
                case 2: {
                    string = "Handlers";
                    break;
                }
                case 3: {
                    string = "Set log file";
                }
            }
            return string;
        }
    }

    class LogElem {
        private String fileName;
        private Object logger;
        private String level;

        public LogElem(Object object, String string, String string2) {
            this.logger = object;
            this.fileName = string;
            this.level = string2;
        }

        public Object getLogger() {
            return this.logger;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String string) {
            this.level = string;
        }

        public void setFileName(String string) {
            this.fileName = string;
        }
    }
}

