/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.rma;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

class InstallMTPDialog
extends JDialog {
    private JPanel topPanel;
    private JLabel containerLabel;
    private DefaultComboBoxModel containerList;
    private JComboBox containerChoice;
    private JLabel classLabel;
    private JTextField classField;
    private JLabel addressLabel;
    private JTextField addressField;
    private JPanel bottomPanel;
    private JButton buttonOK;
    private JButton buttonCancel;
    private boolean confirmed = false;

    public InstallMTPDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.pack();
    }

    public void reset(String[] stringArray, String string) {
        Window window = this.getOwner();
        this.setLocation(window.getX() + (window.getWidth() - this.getWidth()) / 2, window.getY() + (window.getHeight() - this.getHeight()) / 2);
        this.classField.setText(null);
        this.addressField.setText(null);
        this.containerList.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.containerList.addElement(stringArray[n]);
            ++n;
        }
        this.containerList.setSelectedItem(string);
    }

    public String getAddress() {
        String string = this.addressField.getText();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public String getClassName() {
        String string = this.classField.getText();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public String getContainer() {
        return (String)this.containerChoice.getSelectedItem();
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.containerLabel = new JLabel();
        this.containerList = new DefaultComboBoxModel<String>(new String[]{"              "});
        this.containerChoice = new JComboBox(this.containerList);
        this.classLabel = new JLabel();
        this.classField = new JTextField();
        this.addressLabel = new JLabel();
        this.addressField = new JTextField();
        this.bottomPanel = new JPanel();
        this.buttonOK = new JButton();
        this.buttonCancel = new JButton();
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setTitle("Install a new MTP");
        this.setModal(true);
        this.setName("installMTPDlg");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                InstallMTPDialog.this.closeDialog(windowEvent);
            }
        });
        this.topPanel.setLayout(new GridLayout(3, 2, 10, 2));
        this.topPanel.setBorder(new CompoundBorder(new EmptyBorder(new Insets(5, 5, 5, 5)), new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(2, 2, 2, 2)))));
        this.containerLabel.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
        this.containerLabel.setText("Container:");
        this.containerLabel.setFont(new Font("Dialog", 1, 12));
        this.topPanel.add(this.containerLabel);
        this.containerChoice.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
        this.containerChoice.setFont(new Font("Dialog", 0, 12));
        this.topPanel.add(this.containerChoice);
        this.classLabel.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
        this.classLabel.setText("Class Name:");
        this.classLabel.setFont(new Font("Dialog", 1, 12));
        this.topPanel.add(this.classLabel);
        this.classField.setToolTipText("Write here the name of the class implementing the MTP");
        this.topPanel.add(this.classField);
        this.addressLabel.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
        this.addressLabel.setText("Address:");
        this.addressLabel.setFont(new Font("Dialog", 1, 12));
        this.topPanel.add(this.addressLabel);
        this.addressField.setToolTipText("Write here the MTP address, if needed");
        this.topPanel.add(this.addressField);
        this.getContentPane().add((Component)this.topPanel, "Center");
        this.bottomPanel.setLayout(new GridLayout(1, 2, 10, 0));
        this.bottomPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.buttonOK.setText("OK");
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstallMTPDialog.this.buttonOKActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.buttonOK);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InstallMTPDialog.this.buttonCancelActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.buttonCancel);
        this.getContentPane().add((Component)this.bottomPanel, "South");
    }

    private void buttonCancelActionPerformed(ActionEvent actionEvent) {
        this.confirmed = false;
        this.destroy();
    }

    private void buttonOKActionPerformed(ActionEvent actionEvent) {
        this.confirmed = true;
        String string = this.classField.getText();
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(this.getParent(), "The class name for the MTP must be present", "Error during MTP installation.", 0);
        } else {
            this.destroy();
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.confirmed = false;
        this.destroy();
    }

    private void destroy() {
        this.setVisible(false);
        this.dispose();
    }
}

