/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.sniffer;

import jade.gui.AgentTree;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class PopupMouser
extends MouseAdapter {
    JPopupMenu popup;
    JTree tree;
    AgentTree agentTree;
    TreePath[] paths;
    TreeSelectionModel model;

    public PopupMouser(JTree jTree, AgentTree agentTree) {
        this.tree = jTree;
        this.agentTree = agentTree;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.setPopup(mouseEvent)) {
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.setPopup(mouseEvent)) {
            this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private boolean setPopup(MouseEvent mouseEvent) {
        int n = this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n != -1) {
            this.paths = this.tree.getSelectionPaths();
            AgentTree.Node node = (AgentTree.Node)treePath.getLastPathComponent();
            String string = node.getType();
            this.model = this.tree.getSelectionModel();
            if (!this.tree.isRowSelected(n)) {
                this.model.setSelectionPath(treePath);
            } else {
                this.model.setSelectionPaths(this.paths);
                this.sameTypeNode(string);
            }
            this.popup = this.agentTree.getPopupMenu(string);
            return this.popup != null;
        }
        return false;
    }

    private void sameTypeNode(String string) {
        int n = 0;
        while (n < this.paths.length) {
            AgentTree.Node node = (AgentTree.Node)this.paths[n].getLastPathComponent();
            String string2 = node.getType();
            if (!string.equals(string2)) {
                this.model.removeSelectionPath(this.paths[n]);
            }
            ++n;
        }
    }
}

