/*
 * Decompiled with CFR 0.152.
 */
package jade.content;

import jade.content.ContentElement;
import jade.content.abs.AbsContentElement;
import jade.content.lang.ByteArrayCodec;
import jade.content.lang.Codec;
import jade.content.lang.StringCodec;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.schema.ObjectSchema;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ACLMessage;
import jade.util.leap.HashMap;
import jade.util.leap.Map;
import jade.util.leap.Serializable;
import java.io.IOException;
import java.io.ObjectInputStream;

public class ContentManager
implements Serializable {
    private transient Map languages = new HashMap();
    private transient Map ontologies = new HashMap();
    private boolean validationMode = true;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.languages = new HashMap();
        this.ontologies = new HashMap();
    }

    public void registerLanguage(Codec codec) {
        if (codec == null) {
            throw new IllegalArgumentException("Null codec registered");
        }
        this.registerLanguage(codec, codec.getName());
    }

    public void registerLanguage(Codec codec, String string) {
        if (codec == null) {
            throw new IllegalArgumentException("Null codec registered");
        }
        this.languages.put(new CaseInsensitiveString(string), codec);
    }

    public void registerOntology(Ontology ontology) {
        if (ontology == null) {
            throw new IllegalArgumentException("Null ontology registered");
        }
        this.registerOntology(ontology, ontology.getName());
    }

    public void registerOntology(Ontology ontology, String string) {
        if (ontology == null) {
            throw new IllegalArgumentException("Null ontology registered");
        }
        this.ontologies.put(new CaseInsensitiveString(string), ontology);
    }

    public Codec lookupLanguage(String string) {
        return string == null ? null : (Codec)this.languages.get(new CaseInsensitiveString(string));
    }

    public Ontology lookupOntology(String string) {
        return string == null ? null : (Ontology)this.ontologies.get(new CaseInsensitiveString(string));
    }

    public void fillContent(ACLMessage aCLMessage, AbsContentElement absContentElement) throws Codec.CodecException, OntologyException {
        Codec codec = this.lookupLanguage(aCLMessage.getLanguage());
        if (codec == null) {
            throw new Codec.CodecException("Unknown language " + aCLMessage.getLanguage());
        }
        Ontology ontology = this.lookupOntology(aCLMessage.getOntology());
        if (ontology == null) {
            throw new OntologyException("Unknown ontology " + aCLMessage.getOntology());
        }
        Ontology ontology2 = this.getMergedOntology(codec, ontology);
        this.validate(absContentElement, ontology2);
        this.encode(aCLMessage, absContentElement, codec, ontology2);
    }

    public void fillContent(ACLMessage aCLMessage, ContentElement contentElement) throws Codec.CodecException, OntologyException {
        Codec codec = this.lookupLanguage(aCLMessage.getLanguage());
        if (codec == null) {
            throw new Codec.CodecException("Unknown language " + aCLMessage.getLanguage());
        }
        Ontology ontology = this.lookupOntology(aCLMessage.getOntology());
        if (ontology == null) {
            throw new OntologyException("Unknown ontology " + aCLMessage.getOntology());
        }
        Ontology ontology2 = this.getMergedOntology(codec, ontology);
        AbsContentElement absContentElement = (AbsContentElement)ontology2.fromObject(contentElement);
        this.validate(absContentElement, ontology2);
        this.encode(aCLMessage, absContentElement, codec, ontology2);
    }

    public AbsContentElement extractAbsContent(ACLMessage aCLMessage) throws Codec.CodecException, OntologyException {
        Codec codec = this.lookupLanguage(aCLMessage.getLanguage());
        if (codec == null) {
            throw new Codec.CodecException("Unknown language " + aCLMessage.getLanguage());
        }
        Ontology ontology = this.lookupOntology(aCLMessage.getOntology());
        if (ontology == null) {
            throw new OntologyException("Unknown ontology " + aCLMessage.getOntology());
        }
        Ontology ontology2 = this.getMergedOntology(codec, ontology);
        AbsContentElement absContentElement = this.decode(aCLMessage, codec, ontology2);
        this.validate(absContentElement, ontology2);
        return absContentElement;
    }

    public ContentElement extractContent(ACLMessage aCLMessage) throws Codec.CodecException, UngroundedException, OntologyException {
        Codec codec = this.lookupLanguage(aCLMessage.getLanguage());
        if (codec == null) {
            throw new Codec.CodecException("Unknown language " + aCLMessage.getLanguage());
        }
        Ontology ontology = this.lookupOntology(aCLMessage.getOntology());
        if (ontology == null) {
            throw new OntologyException("Unknown ontology " + aCLMessage.getOntology());
        }
        Ontology ontology2 = this.getMergedOntology(codec, ontology);
        AbsContentElement absContentElement = this.decode(aCLMessage, codec, ontology2);
        this.validate(absContentElement, ontology2);
        return (ContentElement)ontology2.toObject(absContentElement);
    }

    public void setValidationMode(boolean bl) {
        this.validationMode = bl;
    }

    public boolean getValidationMode() {
        return this.validationMode;
    }

    public Ontology getOntology(ACLMessage aCLMessage) {
        return this.getMergedOntology(this.lookupLanguage(aCLMessage.getLanguage()), this.lookupOntology(aCLMessage.getOntology()));
    }

    private Ontology getMergedOntology(Codec codec, Ontology ontology) {
        Ontology ontology2 = null;
        Ontology ontology3 = codec.getInnerOntology();
        ontology2 = ontology3 == null ? ontology : new Ontology(null, new Ontology[]{ontology, ontology3}, null);
        return ontology2;
    }

    private void validate(AbsContentElement absContentElement, Ontology ontology) throws OntologyException {
        if (this.validationMode) {
            ObjectSchema objectSchema = ontology.getSchema(absContentElement.getTypeName());
            if (objectSchema == null) {
                throw new OntologyException("No schema found for type " + absContentElement.getTypeName());
            }
            objectSchema.validate(absContentElement, ontology);
        }
    }

    private void encode(ACLMessage aCLMessage, AbsContentElement absContentElement, Codec codec, Ontology ontology) throws Codec.CodecException, OntologyException {
        if (codec instanceof ByteArrayCodec) {
            aCLMessage.setByteSequenceContent(((ByteArrayCodec)codec).encode(ontology, absContentElement));
        } else if (codec instanceof StringCodec) {
            aCLMessage.setContent(((StringCodec)codec).encode(ontology, absContentElement));
        } else {
            throw new Codec.CodecException("UnsupportedTypeOfCodec");
        }
    }

    private AbsContentElement decode(ACLMessage aCLMessage, Codec codec, Ontology ontology) throws Codec.CodecException, OntologyException {
        if (codec instanceof ByteArrayCodec) {
            return ((ByteArrayCodec)codec).decode(ontology, aCLMessage.getByteSequenceContent());
        }
        if (codec instanceof StringCodec) {
            return ((StringCodec)codec).decode(ontology, aCLMessage.getContent());
        }
        throw new Codec.CodecException("UnsupportedTypeOfCodec");
    }
}

