/*
 * Decompiled with CFR 0.152.
 */
package jade.content.abs;

import jade.content.ContentElement;
import jade.content.ContentElementList;
import jade.content.OntoACLMessage;
import jade.content.OntoAID;
import jade.content.abs.AbsAgentAction;
import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsConcept;
import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsIRE;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPredicate;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.abs.AbsVariable;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.core.AID;
import jade.core.CaseInsensitiveString;
import jade.lang.acl.ACLMessage;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;

public class AbsHelper {
    public static AbsAggregate externaliseList(List list, Ontology ontology, String string) throws OntologyException {
        AbsAggregate absAggregate = new AbsAggregate(string);
        try {
            int n = 0;
            while (n < list.size()) {
                absAggregate.add((AbsTerm)ontology.fromObject(list.get(n)));
                ++n;
            }
        }
        catch (ClassCastException classCastException) {
            throw new OntologyException("Non term object in aggregate");
        }
        return absAggregate;
    }

    public static AbsAggregate externaliseIterator(Iterator iterator, Ontology ontology, String string) throws OntologyException {
        AbsAggregate absAggregate = new AbsAggregate(string);
        try {
            while (iterator.hasNext()) {
                absAggregate.add((AbsTerm)ontology.fromObject(iterator.next()));
            }
        }
        catch (ClassCastException classCastException) {
            throw new OntologyException("Non term object in aggregate");
        }
        return absAggregate;
    }

    public static AbsConcept externaliseAID(AID aID) {
        Object object;
        AbsAggregate absAggregate;
        AbsConcept absConcept = new AbsConcept("agent-identifier");
        absConcept.set("name", aID.getName());
        Iterator iterator = aID.getAllAddresses();
        if (iterator.hasNext()) {
            absAggregate = new AbsAggregate("sequence");
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                absAggregate.add(AbsPrimitive.wrap((String)object));
            }
            absConcept.set("addresses", absAggregate);
        }
        if ((iterator = aID.getAllResolvers()).hasNext()) {
            absAggregate = new AbsAggregate("sequence");
            while (iterator.hasNext()) {
                object = (AID)iterator.next();
                absAggregate.add(AbsHelper.externaliseAID((AID)object));
            }
            absConcept.set("resolvers", absAggregate);
        }
        return absConcept;
    }

    public static AbsContentElementList externaliseContentElementList(ContentElementList contentElementList, Ontology ontology) throws OntologyException {
        AbsContentElementList absContentElementList = new AbsContentElementList();
        try {
            int n = 0;
            while (n < contentElementList.size()) {
                absContentElementList.add((AbsContentElement)ontology.fromObject(contentElementList.get(n)));
                ++n;
            }
        }
        catch (ClassCastException classCastException) {
            throw new OntologyException("Non content element object in content element list");
        }
        return absContentElementList;
    }

    public static AbsAgentAction externaliseACLMessage(ACLMessage aCLMessage, Ontology ontology) throws OntologyException {
        try {
            AbsAgentAction absAgentAction = new AbsAgentAction(ACLMessage.getPerformative(aCLMessage.getPerformative()));
            absAgentAction.set("sender", (AbsTerm)ontology.fromObject(aCLMessage.getSender()));
            AbsAggregate absAggregate = new AbsAggregate("sequence");
            Iterator iterator = aCLMessage.getAllReceiver();
            while (iterator.hasNext()) {
                absAggregate.add((AbsTerm)ontology.fromObject(iterator.next()));
            }
            if (absAggregate.size() > 0) {
                absAgentAction.set("receivers", absAggregate);
            }
            AbsAggregate absAggregate2 = new AbsAggregate("sequence");
            iterator = aCLMessage.getAllReplyTo();
            while (iterator.hasNext()) {
                absAggregate2.add((AbsTerm)ontology.fromObject(iterator.next()));
            }
            if (absAggregate2.size() > 0) {
                absAgentAction.set("reply-to", absAggregate2);
            }
            absAgentAction.set("language", aCLMessage.getLanguage());
            absAgentAction.set("ontology", aCLMessage.getOntology());
            absAgentAction.set("protocol", aCLMessage.getProtocol());
            absAgentAction.set("in-reply-to", aCLMessage.getInReplyTo());
            absAgentAction.set("reply-with", aCLMessage.getReplyWith());
            absAgentAction.set("conversation-id", aCLMessage.getConversationId());
            absAgentAction.set("reply-by", aCLMessage.getReplyByDate());
            if (aCLMessage.hasByteSequenceContent()) {
                absAgentAction.set("bs-content", aCLMessage.getByteSequenceContent());
            } else {
                absAgentAction.set("content", aCLMessage.getContent());
            }
            absAgentAction.set("encoding", aCLMessage.getEncoding());
            return absAgentAction;
        }
        catch (Exception exception) {
            throw new OntologyException("Error externalising ACLMessage", exception);
        }
    }

    public static List internaliseList(AbsAggregate absAggregate, Ontology ontology) throws OntologyException {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < absAggregate.size()) {
            Object object = ontology.toObject(absAggregate.get(n));
            Ontology.checkIsTerm(object);
            arrayList.add(object);
            ++n;
        }
        return arrayList;
    }

    public static OntoAID internaliseAID(AbsConcept absConcept) throws OntologyException {
        OntoAID ontoAID = new OntoAID();
        try {
            AbsAggregate absAggregate;
            ontoAID.setName(absConcept.getString("name"));
            AbsAggregate absAggregate2 = (AbsAggregate)absConcept.getAbsObject("addresses");
            if (absAggregate2 != null) {
                int n = 0;
                while (n < absAggregate2.size()) {
                    String string = ((AbsPrimitive)absAggregate2.get(n)).getString();
                    ontoAID.addAddresses(string);
                    ++n;
                }
            }
            if ((absAggregate = (AbsAggregate)absConcept.getAbsObject("resolvers")) != null) {
                int n = 0;
                while (n < absAggregate.size()) {
                    OntoAID ontoAID2 = AbsHelper.internaliseAID((AbsConcept)absAggregate.get(n));
                    ontoAID.addResolvers(ontoAID2);
                    ++n;
                }
            }
            return ontoAID;
        }
        catch (Exception exception) {
            throw new OntologyException(absConcept + " is not a valid AID");
        }
    }

    public static ContentElementList internaliseContentElementList(AbsContentElementList absContentElementList, Ontology ontology) throws OntologyException {
        ContentElementList contentElementList = new ContentElementList();
        try {
            int n = 0;
            while (n < absContentElementList.size()) {
                ContentElement contentElement = (ContentElement)ontology.toObject(absContentElementList.get(n));
                contentElementList.add(contentElement);
                ++n;
            }
        }
        catch (ClassCastException classCastException) {
            throw new OntologyException("Non content element object in content element list");
        }
        return contentElementList;
    }

    public static OntoACLMessage internaliseACLMessage(AbsAgentAction absAgentAction, Ontology ontology) throws OntologyException {
        OntoACLMessage ontoACLMessage = new OntoACLMessage(ACLMessage.getInteger(absAgentAction.getTypeName()));
        try {
            Object object;
            ontoACLMessage.setSender((AID)ontology.toObject(absAgentAction.getAbsObject("sender")));
            ontoACLMessage.clearAllReceiver();
            List list = (List)ontology.toObject(absAgentAction.getAbsObject("receivers"));
            if (list != null) {
                object = list.iterator();
                while (object.hasNext()) {
                    ontoACLMessage.addReceiver((AID)object.next());
                }
            }
            ontoACLMessage.clearAllReplyTo();
            list = (List)ontology.toObject(absAgentAction.getAbsObject("reply-to"));
            if (list != null) {
                object = list.iterator();
                while (object.hasNext()) {
                    ontoACLMessage.addReplyTo((AID)object.next());
                }
            }
            ontoACLMessage.setLanguage(absAgentAction.getString("language"));
            ontoACLMessage.setOntology(absAgentAction.getString("ontology"));
            ontoACLMessage.setProtocol(absAgentAction.getString("protocol"));
            ontoACLMessage.setInReplyTo(absAgentAction.getString("in-reply-to"));
            ontoACLMessage.setReplyWith(absAgentAction.getString("reply-with"));
            ontoACLMessage.setConversationId(absAgentAction.getString("conversation-id"));
            ontoACLMessage.setReplyByDate(absAgentAction.getDate("reply-by"));
            object = absAgentAction.getString("content");
            if (object != null) {
                ontoACLMessage.setContent((String)object);
            } else {
                byte[] byArray = absAgentAction.getByteSequence("bs-content");
                if (byArray != null) {
                    ontoACLMessage.setByteSequenceContent(byArray);
                }
            }
            ontoACLMessage.setEncoding(absAgentAction.getString("encoding"));
            return ontoACLMessage;
        }
        catch (Exception exception) {
            throw new OntologyException("Error internalising OntoACLMessage", exception);
        }
    }

    public static void setAttribute(AbsObject absObject, String string, AbsObject absObject2) throws OntologyException {
        if (absObject instanceof AbsAgentAction) {
            if (absObject2 instanceof AbsTerm) {
                ((AbsAgentAction)absObject).set(string, (AbsTerm)absObject2);
                return;
            }
            if (absObject2 instanceof AbsPredicate) {
                ((AbsAgentAction)absObject).set(string, (AbsPredicate)absObject2);
                return;
            }
        }
        if (absObject instanceof AbsConcept) {
            if (absObject2 instanceof AbsTerm) {
                ((AbsConcept)absObject).set(string, (AbsTerm)absObject2);
                return;
            }
        } else {
            if (absObject instanceof AbsPredicate) {
                ((AbsPredicate)absObject).set(string, absObject2);
                return;
            }
            if (absObject instanceof AbsIRE) {
                if (absObject2 instanceof AbsVariable && CaseInsensitiveString.equalsIgnoreCase(string, "Variable")) {
                    ((AbsIRE)absObject).setVariable((AbsVariable)absObject2);
                    return;
                }
                if (absObject2 instanceof AbsPredicate && CaseInsensitiveString.equalsIgnoreCase(string, "Proposition")) {
                    ((AbsIRE)absObject).setProposition((AbsPredicate)absObject2);
                    return;
                }
            } else if (absObject instanceof AbsVariable) {
                if (absObject2 instanceof AbsPrimitive && CaseInsensitiveString.equalsIgnoreCase(string, "Name")) {
                    ((AbsVariable)absObject).setName(((AbsPrimitive)absObject2).getString());
                    return;
                }
                if (absObject2 instanceof AbsPrimitive && CaseInsensitiveString.equalsIgnoreCase(string, "ValueType")) {
                    ((AbsVariable)absObject).setType(((AbsPrimitive)absObject2).getString());
                    return;
                }
            }
        }
        throw new OntologyException("Type incompatibility: attribute " + string + " of " + absObject + " is of type " + absObject2);
    }
}

