/*
 * Decompiled with CFR 0.152.
 */
package jade.content.lang.leap;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsContentElement;
import jade.content.abs.AbsContentElementList;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.abs.AbsPrimitive;
import jade.content.abs.AbsTerm;
import jade.content.lang.ByteArrayCodec;
import jade.content.lang.Codec;
import jade.content.onto.Ontology;
import jade.content.schema.ObjectSchema;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import java.util.Vector;

public class LEAPCodec
extends ByteArrayCodec {
    public static final String NAME = "LEAP";
    private transient ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
    private transient DataOutputStream outStream = new DataOutputStream(this.outBuffer);
    private transient Vector stringReferences = new Vector();
    private static final byte PRIMITIVE = 0;
    private static final byte AGGREGATE = 1;
    private static final byte CONTENT_ELEMENT_LIST = 2;
    private static final byte OBJECT = 3;
    private static final byte ELEMENT = 4;
    private static final byte END = 5;
    private static final byte STRING = 6;
    private static final byte BOOLEAN = 7;
    private static final byte INTEGER = 8;
    private static final byte FLOAT = 9;
    private static final byte DATE = 10;
    private static final byte BYTE_SEQUENCE = 11;
    private static final byte MODIFIER = 16;
    private static final byte UNMODIFIER = -17;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.outBuffer = new ByteArrayOutputStream();
        this.outStream = new DataOutputStream(this.outBuffer);
        this.stringReferences = new Vector();
    }

    public LEAPCodec() {
        super(NAME);
    }

    public synchronized byte[] encode(AbsContentElement absContentElement) throws Codec.CodecException {
        try {
            this.outBuffer.reset();
            this.stringReferences.removeAllElements();
            this.write(this.outStream, absContentElement);
            return this.outBuffer.toByteArray();
        }
        catch (Throwable throwable) {
            throw new Codec.CodecException("Error encoding content", throwable);
        }
    }

    public byte[] encode(Ontology ontology, AbsContentElement absContentElement) throws Codec.CodecException {
        return this.encode(absContentElement);
    }

    public AbsContentElement decode(byte[] byArray) throws Codec.CodecException {
        throw new Codec.CodecException("Not supported");
    }

    public synchronized AbsContentElement decode(Ontology ontology, byte[] byArray) throws Codec.CodecException {
        if (byArray.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.stringReferences.removeAllElements();
            AbsObject absObject = this.read(dataInputStream, ontology);
            dataInputStream.close();
            return (AbsContentElement)absObject;
        }
        catch (Throwable throwable) {
            throw new Codec.CodecException("Error decoding content", throwable);
        }
    }

    private void write(DataOutputStream dataOutputStream, AbsObject absObject) throws Throwable {
        if (absObject instanceof AbsPrimitive) {
            Object object = ((AbsPrimitive)absObject).getObject();
            if (object instanceof String) {
                this.writeString(dataOutputStream, (byte)6, (String)object);
            }
            if (object instanceof Boolean) {
                dataOutputStream.writeByte(7);
                dataOutputStream.writeBoolean((Boolean)object);
            }
            if (object instanceof Long) {
                dataOutputStream.writeByte(8);
                dataOutputStream.writeLong((Long)object);
            }
            if (object instanceof Double) {
                dataOutputStream.writeByte(9);
                dataOutputStream.writeDouble((Double)object);
            }
            if (object instanceof Date) {
                dataOutputStream.writeByte(10);
                dataOutputStream.writeLong(((Date)object).getTime());
            }
            if (object instanceof byte[]) {
                dataOutputStream.writeByte(11);
                byte[] byArray = (byte[])object;
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray, 0, byArray.length);
            }
            return;
        }
        if (absObject instanceof AbsAggregate) {
            this.writeString(dataOutputStream, (byte)1, absObject.getTypeName());
            AbsAggregate absAggregate = (AbsAggregate)absObject;
            int n = 0;
            while (n < absAggregate.size()) {
                dataOutputStream.writeByte(4);
                this.write(dataOutputStream, absAggregate.get(n));
                ++n;
            }
            dataOutputStream.writeByte(5);
            return;
        }
        if (absObject instanceof AbsContentElementList) {
            dataOutputStream.writeByte(2);
            AbsContentElementList absContentElementList = (AbsContentElementList)absObject;
            int n = 0;
            while (n < absContentElementList.size()) {
                dataOutputStream.writeByte(4);
                this.write(dataOutputStream, absContentElementList.get(n));
                ++n;
            }
            dataOutputStream.writeByte(5);
            return;
        }
        this.writeString(dataOutputStream, (byte)3, absObject.getTypeName());
        String[] stringArray = absObject.getNames();
        int n = 0;
        while (n < absObject.getCount()) {
            this.writeString(dataOutputStream, (byte)4, stringArray[n]);
            AbsObject absObject2 = absObject.getAbsObject(stringArray[n]);
            this.write(dataOutputStream, absObject2);
            ++n;
        }
        dataOutputStream.writeByte(5);
    }

    private synchronized AbsObject read(DataInputStream dataInputStream, Ontology ontology) throws Throwable {
        byte by = dataInputStream.readByte();
        if ((by & 0xFFFFFFEF) == 6) {
            return AbsPrimitive.wrap(this.readString(dataInputStream, by));
        }
        if (by == 7) {
            boolean bl = dataInputStream.readBoolean();
            return AbsPrimitive.wrap(bl);
        }
        if (by == 8) {
            long l = dataInputStream.readLong();
            return AbsPrimitive.wrap(l);
        }
        if (by == 9) {
            double d = dataInputStream.readDouble();
            return AbsPrimitive.wrap(d);
        }
        if (by == 10) {
            long l = dataInputStream.readLong();
            return AbsPrimitive.wrap(new Date(l));
        }
        if (by == 11) {
            byte[] byArray = new byte[dataInputStream.readInt()];
            dataInputStream.read(byArray, 0, byArray.length);
            return AbsPrimitive.wrap(byArray);
        }
        if ((by & 0xFFFFFFEF) == 1) {
            String string = this.readString(dataInputStream, by);
            AbsAggregate absAggregate = new AbsAggregate(string);
            byte by2 = dataInputStream.readByte();
            do {
                if (by2 != 4) continue;
                AbsObject absObject = this.read(dataInputStream, ontology);
                if (absObject != null) {
                    try {
                        absAggregate.add((AbsTerm)absObject);
                    }
                    catch (ClassCastException classCastException) {
                        throw new Codec.CodecException("Non term element in aggregate");
                    }
                }
                by2 = dataInputStream.readByte();
            } while (by2 != 5);
            return absAggregate;
        }
        if (by == 2) {
            AbsContentElementList absContentElementList = new AbsContentElementList();
            byte by3 = dataInputStream.readByte();
            do {
                if (by3 != 4) continue;
                AbsObject absObject = this.read(dataInputStream, ontology);
                if (absObject != null) {
                    try {
                        absContentElementList.add((AbsContentElement)absObject);
                    }
                    catch (ClassCastException classCastException) {
                        throw new Codec.CodecException("Non content-element element in content-element-list");
                    }
                }
                by3 = dataInputStream.readByte();
            } while (by3 != 5);
            return absContentElementList;
        }
        String string = this.readString(dataInputStream, by);
        ObjectSchema objectSchema = ontology.getSchema(string);
        AbsObject absObject = objectSchema.newInstance();
        byte by4 = dataInputStream.readByte();
        do {
            if ((by4 & 0xFFFFFFEF) != 4) continue;
            String string2 = this.readString(dataInputStream, by4);
            AbsObject absObject2 = this.read(dataInputStream, ontology);
            if (absObject2 != null) {
                AbsHelper.setAttribute(absObject, string2, absObject2);
            }
            by4 = dataInputStream.readByte();
        } while (by4 != 5);
        return absObject;
    }

    private final void writeString(DataOutputStream dataOutputStream, byte by, String string) throws Throwable {
        int n = this.stringReferences.indexOf(string);
        if (n >= 0) {
            dataOutputStream.writeByte(by | 0x10);
            dataOutputStream.writeByte(n);
        } else {
            dataOutputStream.writeByte(by);
            dataOutputStream.writeUTF(string);
            if (string.length() > 1 && this.stringReferences.size() < 256) {
                this.stringReferences.addElement(string);
            }
        }
    }

    private final String readString(DataInputStream dataInputStream, byte by) throws Throwable {
        if ((by & 0x10) != 0) {
            int n = dataInputStream.readUnsignedByte();
            return (String)this.stringReferences.elementAt(n);
        }
        String string = dataInputStream.readUTF();
        if (string.length() > 1 && this.stringReferences.size() < 256) {
            this.stringReferences.addElement(string);
        }
        return string;
    }
}

