/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.content.ContentManager;
import jade.core.AID;
import jade.core.AgentState;
import jade.core.AgentToolkit;
import jade.core.DummyToolkit;
import jade.core.LifeCycle;
import jade.core.Location;
import jade.core.MessageQueue;
import jade.core.Scheduler;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.core.Timer;
import jade.core.TimerDispatcher;
import jade.core.TimerListener;
import jade.core.behaviours.Behaviour;
import jade.core.mobility.AgentMobilityHelper;
import jade.core.mobility.Movable;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.security.Credentials;
import jade.security.CredentialsHelper;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.List;
import jade.util.leap.Map;
import jade.util.leap.Serializable;
import jade.wrapper.AgentContainer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class Agent
implements Runnable,
Serializable,
TimerListener {
    private static final long serialVersionUID = 3487495895819000L;
    public static final int AP_MIN = 0;
    public static final int AP_INITIATED = 1;
    public static final int AP_ACTIVE = 2;
    public static final int AP_IDLE = 3;
    public static final int AP_SUSPENDED = 4;
    public static final int AP_WAITING = 5;
    public static final int AP_DELETED = 6;
    public static final int AP_MAX = 13;
    public static final int D_MIN = 9;
    public static final int D_ACTIVE = 10;
    public static final int D_SUSPENDED = 20;
    public static final int D_RETIRED = 30;
    public static final int D_UNKNOWN = 40;
    public static final int D_MAX = 41;
    private transient MessageQueue msgQueue;
    private transient AgentToolkit myToolkit;
    private int msgQueueMaxSize = 0;
    private transient List o2aQueue;
    private int o2aQueueSize = 0;
    private transient Map o2aLocks;
    private transient Object suspendLock;
    private String myName = null;
    private AID myAID = null;
    private String myHap = null;
    private transient Object stateLock;
    private transient Thread myThread;
    private transient TimerDispatcher theDispatcher;
    private Scheduler myScheduler;
    private transient AssociationTB pendingTimers;
    private int messageCounter = 0;
    private LifeCycle myLifeCycle;
    private LifeCycle myBufferedLifeCycle;
    private LifeCycle myActiveLifeCycle;
    private transient LifeCycle myDeletedLifeCycle;
    private transient LifeCycle mySuspendedLifeCycle;
    private boolean terminating = false;
    private boolean generateBehaviourEvents = false;
    private Long persistentID;
    private transient AgentContainer myContainer = null;
    private transient Object[] arguments = null;
    private transient AgentMobilityHelper mobHelper;
    private ContentManager theContentManager = null;
    private transient Hashtable helpersTable;
    private transient Set persistentPendingTimers = new HashSet();

    public void restartLater(Behaviour behaviour, long l) {
        if (l <= 0L) {
            return;
        }
        Timer timer = new Timer(System.currentTimeMillis() + l, this);
        this.pendingTimers.addPair(behaviour, timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTimeOut(Timer timer) {
        Behaviour behaviour = null;
        TimerDispatcher timerDispatcher = this.theDispatcher;
        synchronized (timerDispatcher) {
            behaviour = this.pendingTimers.getPeer(timer);
            if (behaviour != null) {
                this.pendingTimers.removeMapping(behaviour);
            }
        }
        if (behaviour != null) {
            behaviour.restart();
        } else {
            System.out.println("Warning: No mapping found for expired timer " + timer.expirationTime());
        }
    }

    public void notifyRestarted(Behaviour behaviour) {
        Behaviour behaviour2;
        Timer timer = this.pendingTimers.getPeer(behaviour);
        if (timer != null) {
            this.pendingTimers.removeMapping(behaviour);
        }
        if ((behaviour2 = behaviour.root()).isRunnable()) {
            this.myScheduler.restart(behaviour2);
        }
    }

    public final AID getAMS() {
        return this.myToolkit.getAMS();
    }

    public final AID getDefaultDF() {
        return this.myToolkit.getDefaultDF();
    }

    private void setTerminating(boolean bl) {
        this.terminating = bl;
    }

    private boolean getTerminating() {
        return this.terminating;
    }

    public Agent() {
        this.myToolkit = DummyToolkit.instance();
        this.o2aLocks = new HashMap();
        this.msgQueue = new MessageQueue(this.msgQueueMaxSize);
        this.suspendLock = new Object();
        this.stateLock = new Object();
        this.pendingTimers = new AssociationTB();
        this.myLifeCycle = this.myActiveLifeCycle = new ActiveLifeCycle();
        this.myScheduler = new Scheduler(this);
        this.theDispatcher = TimerDispatcher.getTimerDispatcher();
    }

    Agent(AID aID) {
        this.setAID(aID);
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }

    public final AgentContainer getContainerController() {
        if (this.myContainer == null) {
            try {
                JADEPrincipal jADEPrincipal = null;
                Credentials credentials = null;
                try {
                    CredentialsHelper credentialsHelper = (CredentialsHelper)((Object)this.getHelper("jade.core.security.Security"));
                    jADEPrincipal = credentialsHelper.getPrincipal();
                    credentials = credentialsHelper.getCredentials();
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                this.myContainer = this.myToolkit.getContainerController(jADEPrincipal, credentials);
            }
            catch (Exception exception) {
                throw new IllegalStateException("A ContainerController cannot be got for this agent. Probably the method has been called at an appropriate time before the complete initialization of the agent.");
            }
        }
        return this.myContainer;
    }

    public final void setArguments(Object[] objectArray) {
        this.arguments = objectArray;
    }

    protected Object[] getArguments() {
        return this.arguments;
    }

    public final String getLocalName() {
        return this.myName;
    }

    public final String getName() {
        if (this.myHap != null) {
            return this.myName + '@' + this.myHap;
        }
        return this.myName;
    }

    public final String getHap() {
        return this.myHap;
    }

    public final AID getAID() {
        return this.myAID;
    }

    void setAID(AID aID) {
        this.myName = aID.getLocalName();
        this.myHap = aID.getHap();
        this.myAID = aID;
    }

    synchronized void addPlatformAddress(String string) {
        if (this.myAID != null) {
            this.myAID = (AID)this.myAID.clone();
            this.myAID.addAddresses(string);
        }
    }

    synchronized void removePlatformAddress(String string) {
        if (this.myAID != null) {
            this.myAID = (AID)this.myAID.clone();
            this.myAID.removeAddresses(string);
        }
    }

    public Location here() {
        return this.myToolkit.here();
    }

    void join() {
        block4: {
            try {
                if (this.myThread == null) {
                    return;
                }
                this.myThread.join(5000L);
                if (!this.myThread.isAlive()) break block4;
                System.out.println("*** Warning: Agent " + this.myName + " did not terminate when requested to do so.");
                if (!this.myThread.equals(Thread.currentThread())) {
                    this.myThread.interrupt();
                    System.out.println("*** Second interrupt issued.");
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void setQueueSize(int n) throws IllegalArgumentException {
        this.msgQueue.setMaxSize(n);
        this.msgQueueMaxSize = n;
    }

    public int getCurQueueSize() {
        return this.msgQueue.size();
    }

    public int getQueueSize() {
        return this.msgQueue.getMaxSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeStateTo(LifeCycle lifeCycle) {
        boolean bl = false;
        lifeCycle.setAgent(this);
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.myLifeCycle.equals(lifeCycle) && this.myLifeCycle.transitionTo(lifeCycle)) {
                this.myBufferedLifeCycle = this.myLifeCycle;
                this.myLifeCycle = lifeCycle;
                bl = true;
                this.notifyChangedAgentState(this.myBufferedLifeCycle.getState(), this.myLifeCycle.getState());
            }
        }
        if (bl) {
            this.myLifeCycle.transitionFrom(this.myBufferedLifeCycle);
            if (!Thread.currentThread().equals(this.myThread)) {
                this.interruptThread();
            }
        }
    }

    public void restoreBufferedState() {
        System.out.println("Restoring buffered state " + this.myBufferedLifeCycle.getState());
        this.changeStateTo(this.myBufferedLifeCycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveState(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.myLifeCycle == this.myActiveLifeCycle) {
                int n2 = this.myLifeCycle.getState();
                if (n != n2) {
                    ((ActiveLifeCycle)this.myLifeCycle).setState(n);
                    this.notifyChangedAgentState(n2, n);
                }
            } else {
                throw new Interrupted();
            }
        }
    }

    public int getState() {
        return this.myLifeCycle.getState();
    }

    public AgentState getAgentState() {
        return AgentState.getInstance(this.getState());
    }

    Scheduler getScheduler() {
        return this.myScheduler;
    }

    MessageQueue getMessageQueue() {
        return this.msgQueue;
    }

    private void setMessageQueue(MessageQueue messageQueue) {
        this.msgQueue = messageQueue;
    }

    private void initMobHelper() throws ServiceException {
        if (this.mobHelper == null) {
            this.mobHelper = (AgentMobilityHelper)this.getHelper("jade.core.mobility.AgentMobility");
            this.mobHelper.registerMovable(new Movable(){

                public void beforeMove() {
                    Agent.this.beforeMove();
                }

                public void afterMove() {
                    Agent.this.afterMove();
                }

                public void beforeClone() {
                    Agent.this.beforeClone();
                }

                public void afterClone() {
                    Agent.this.afterClone();
                }
            });
        }
    }

    public void doMove(Location location) {
        try {
            this.initMobHelper();
            this.mobHelper.move(location);
        }
        catch (ServiceException serviceException) {
            return;
        }
    }

    public void doClone(Location location, String string) {
        try {
            this.initMobHelper();
            this.mobHelper.clone(location, string);
        }
        catch (ServiceException serviceException) {
            return;
        }
    }

    public void doSuspend() {
        if (this.mySuspendedLifeCycle == null) {
            this.mySuspendedLifeCycle = new SuspendedLifeCycle();
        }
        this.changeStateTo(this.mySuspendedLifeCycle);
    }

    public void doActivate() {
        this.restoreBufferedState();
    }

    public void doWait() {
        this.doWait(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWait(long l) {
        if (Thread.currentThread().equals(this.myThread)) {
            this.setActiveState(5);
            MessageQueue messageQueue = this.msgQueue;
            synchronized (messageQueue) {
                try {
                    this.waitOn(this.msgQueue, l);
                }
                catch (InterruptedException interruptedException) {
                    if (this.myLifeCycle != this.myActiveLifeCycle && !this.terminating) {
                        throw new Interrupted();
                    }
                    System.out.println("Agent " + this.getName() + " interrupted while waiting");
                }
                this.setActiveState(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWake() {
        Object object = this.stateLock;
        synchronized (object) {
            int n = this.myLifeCycle.getState();
            if (n == 5 || n == 3) {
                this.setActiveState(2);
            }
        }
        if (this.myLifeCycle.getState() == 2) {
            this.activateAllBehaviours();
            MessageQueue messageQueue = this.msgQueue;
            synchronized (messageQueue) {
                this.msgQueue.notifyAll();
            }
        }
    }

    public void doDelete() {
        if (this.myDeletedLifeCycle == null) {
            this.myDeletedLifeCycle = new DeletedLifeCycle();
        }
        this.changeStateTo(this.myDeletedLifeCycle);
    }

    void idle() throws InterruptedException {
        this.setActiveState(3);
        this.waitOn(this.myScheduler, 0L);
        this.setActiveState(2);
    }

    public void write(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeUTF(this.myName);
        objectOutputStream.writeObject(this);
    }

    public void restore(InputStream inputStream) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putO2AObject(Object object, boolean bl) throws InterruptedException {
        if (this.o2aQueue == null) {
            return;
        }
        CondVar condVar = null;
        List list = this.o2aQueue;
        synchronized (list) {
            if (this.o2aQueueSize != 0 && this.o2aQueue.size() == this.o2aQueueSize) {
                this.o2aQueue.remove(0);
            }
            this.o2aQueue.add(object);
            if (bl) {
                condVar = new CondVar();
                this.o2aLocks.put(object, condVar);
            }
        }
        this.activateAllBehaviours();
        if (bl) {
            condVar.waitOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getO2AObject() {
        if (this.o2aQueue == null) {
            return null;
        }
        CondVar condVar = null;
        Object object = null;
        List list = this.o2aQueue;
        synchronized (list) {
            if (this.o2aQueue.isEmpty()) {
                return null;
            }
            object = this.o2aQueue.remove(0);
            condVar = (CondVar)this.o2aLocks.remove(object);
        }
        if (condVar != null) {
            condVar.set();
        }
        return object;
    }

    public void setEnabledO2ACommunication(boolean bl, int n) {
        if (bl) {
            if (this.o2aQueue == null) {
                this.o2aQueue = new ArrayList(n);
            }
            if (n >= 0) {
                this.o2aQueueSize = n;
            }
        } else {
            jade.util.leap.Iterator iterator = this.o2aLocks.values().iterator();
            while (iterator.hasNext()) {
                CondVar condVar = (CondVar)iterator.next();
                if (condVar == null) continue;
                condVar.set();
            }
            this.o2aQueue = null;
        }
    }

    public final void run() {
        try {
            this.myLifeCycle.init();
            while (this.myLifeCycle.alive()) {
                try {
                    this.myLifeCycle.execute();
                    Thread.yield();
                }
                catch (JADESecurityException jADESecurityException) {
                    System.out.println("JADESecurityException: " + jADESecurityException.getMessage());
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (Interrupted interrupted) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println("***  Uncaught Exception for agent " + this.myName + "  ***");
            throwable.printStackTrace();
        }
        this.terminating = true;
        this.myLifeCycle.end();
    }

    public void clean(boolean bl) {
        if (!bl) {
            System.out.println("ERROR: Agent " + this.myName + " died without being properly terminated !!!");
            System.out.println("State was " + this.myLifeCycle.getState());
        }
        this.myBufferedLifeCycle = this.myLifeCycle;
        this.myLifeCycle = this.myActiveLifeCycle;
        this.takeDown();
        this.pendingTimers.clear();
        this.myToolkit.handleEnd(this.myAID);
        this.myLifeCycle = this.myBufferedLifeCycle;
    }

    protected void setup() {
    }

    protected void takeDown() {
    }

    protected void beforeMove() {
    }

    protected void afterMove() {
    }

    protected void beforeClone() {
    }

    protected void afterClone() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void powerUp(AID aID, Thread thread) {
        this.myName = aID.getLocalName();
        this.myHap = aID.getHap();
        Agent agent = this;
        synchronized (agent) {
            this.myAID = aID;
            this.myToolkit.setPlatformAddresses(this.myAID);
        }
        this.myThread = thread;
        this.myThread.start();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.msgQueueMaxSize = this.msgQueue.getMaxSize();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.msgQueue = new MessageQueue(this.msgQueueMaxSize);
        this.stateLock = new Object();
        this.suspendLock = new Object();
        this.pendingTimers = new AssociationTB();
        this.theDispatcher = TimerDispatcher.getTimerDispatcher();
        if (this.o2aQueueSize > 0) {
            this.o2aQueue = new ArrayList(this.o2aQueueSize);
        }
        this.o2aLocks = new HashMap();
        this.myToolkit = DummyToolkit.instance();
        this.persistentPendingTimers = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilWake(long l) {
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            try {
                this.waitOn(this.msgQueue, l);
            }
            catch (InterruptedException interruptedException) {
                throw new Interrupted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilActivate() throws InterruptedException {
        Object object = this.suspendLock;
        synchronized (object) {
            this.waitOn(this.suspendLock, 0L);
        }
    }

    public void addBehaviour(Behaviour behaviour) {
        behaviour.setAgent(this);
        this.myScheduler.add(behaviour);
    }

    public void removeBehaviour(Behaviour behaviour) {
        behaviour.setAgent(null);
        this.myScheduler.remove(behaviour);
    }

    public final void send(ACLMessage aCLMessage) {
        try {
            aCLMessage.getSender().getName().charAt(0);
        }
        catch (Exception exception) {
            aCLMessage.setSender(this.myAID);
        }
        this.myToolkit.handleSend(aCLMessage, this.myAID, true);
    }

    public final ACLMessage receive() {
        return this.receive(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ACLMessage receive(MessageTemplate messageTemplate) {
        ACLMessage aCLMessage = null;
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            jade.util.leap.Iterator iterator = this.msgQueue.iterator();
            while (iterator.hasNext()) {
                ACLMessage aCLMessage2 = (ACLMessage)iterator.next();
                if (messageTemplate != null && !messageTemplate.match(aCLMessage2)) continue;
                this.msgQueue.remove(aCLMessage2);
                this.myToolkit.handleReceived(this.myAID, aCLMessage2);
                aCLMessage = aCLMessage2;
                break;
            }
        }
        return aCLMessage;
    }

    public final ACLMessage blockingReceive() {
        return this.blockingReceive(null, 0L);
    }

    public final ACLMessage blockingReceive(long l) {
        return this.blockingReceive(null, l);
    }

    public final ACLMessage blockingReceive(MessageTemplate messageTemplate) {
        return this.blockingReceive(messageTemplate, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ACLMessage blockingReceive(MessageTemplate messageTemplate, long l) {
        ACLMessage aCLMessage = null;
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            aCLMessage = this.receive(messageTemplate);
            long l2 = l;
            while (aCLMessage == null) {
                long l3 = System.currentTimeMillis();
                if (Thread.currentThread().equals(this.myThread)) {
                    this.doWait(l2);
                } else {
                    this.waitUntilWake(l2);
                }
                long l4 = System.currentTimeMillis() - l3;
                aCLMessage = this.receive(messageTemplate);
                if (l != 0L && (l2 -= l4) <= 0L) break;
            }
        }
        return aCLMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putBack(ACLMessage aCLMessage) {
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            this.msgQueue.addFirst(aCLMessage);
        }
    }

    final void setToolkit(AgentToolkit agentToolkit) {
        this.myToolkit = agentToolkit;
    }

    final void resetToolkit() {
        this.myToolkit = DummyToolkit.instance();
    }

    public synchronized void waitUntilStarted() {
        while (this.myLifeCycle.getState() == 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void notifyStarted() {
        this.notifyAll();
    }

    void notifyAddBehaviour(Behaviour behaviour) {
        if (this.generateBehaviourEvents) {
            this.myToolkit.handleBehaviourAdded(this.myAID, behaviour);
        }
    }

    void notifyRemoveBehaviour(Behaviour behaviour) {
        if (this.generateBehaviourEvents) {
            this.myToolkit.handleBehaviourRemoved(this.myAID, behaviour);
        }
    }

    public void notifyChangeBehaviourState(Behaviour behaviour, String string, String string2) {
        if (this.generateBehaviourEvents) {
            this.myToolkit.handleChangeBehaviourState(this.myAID, behaviour, string, string2);
        }
    }

    public void setGenerateBehaviourEvents(boolean bl) {
        this.generateBehaviourEvents = bl;
    }

    private boolean getGenerateBehaviourEvents() {
        return this.generateBehaviourEvents;
    }

    private void notifyChangedAgentState(int n, int n2) {
        this.myToolkit.handleChangedAgentState(this.myAID, n, n2);
    }

    private void activateAllBehaviours() {
        this.myScheduler.restartAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postMessage(ACLMessage aCLMessage) {
        MessageQueue messageQueue = this.msgQueue;
        synchronized (messageQueue) {
            if (aCLMessage != null) {
                this.myToolkit.handlePosted(this.myAID, aCLMessage);
                this.msgQueue.addLast(aCLMessage);
                this.doWake();
                ++this.messageCounter;
            }
        }
    }

    public ContentManager getContentManager() {
        if (this.theContentManager == null) {
            this.theContentManager = new ContentManager();
        }
        return this.theContentManager;
    }

    public ServiceHelper getHelper(String string) throws ServiceException {
        ServiceHelper serviceHelper = null;
        if (this.helpersTable == null) {
            this.helpersTable = new Hashtable();
        }
        if ((serviceHelper = (ServiceHelper)this.helpersTable.get(string)) == null) {
            serviceHelper = this.myToolkit.getHelper(this, string);
            if (serviceHelper != null) {
                serviceHelper.init(this);
                this.helpersTable.put(string, serviceHelper);
            } else {
                throw new ServiceException("Null helper");
            }
        }
        return serviceHelper;
    }

    public String getProperty(String string, String string2) {
        String string3;
        String string4 = this.myToolkit.getProperty(string, string2);
        if ((string4 == null || string4.equals(string2)) && (string3 = System.getProperty(string)) != null) {
            string4 = string3;
        }
        return string4;
    }

    private void interruptThread() {
        this.myThread.interrupt();
    }

    void waitOn(Object object, long l) throws InterruptedException {
        object.wait(l);
    }

    private Set getBehaviours() {
        Behaviour[] behaviourArray = this.myScheduler.getBehaviours();
        HashSet<Behaviour> hashSet = new HashSet<Behaviour>();
        hashSet.addAll(Arrays.asList(behaviourArray));
        return hashSet;
    }

    private void setBehaviours(Set set) {
        Behaviour[] behaviourArray = new Behaviour[set.size()];
        behaviourArray = set.toArray(behaviourArray);
        int n = 0;
        while (n < behaviourArray.length) {
            behaviourArray[n].setAgent(this);
            ++n;
        }
        this.myScheduler.setBehaviours(behaviourArray);
    }

    private Set getPendingTimers() {
        return this.persistentPendingTimers;
    }

    private void setPendingTimers(Set set) {
        if (!this.persistentPendingTimers.equals(set)) {
            this.pendingTimers.clear();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                TBPair tBPair = (TBPair)iterator.next();
                this.pendingTimers.addPair(tBPair);
            }
        }
        this.persistentPendingTimers = set;
    }

    private class SuspendedLifeCycle
    extends LifeCycle {
        private SuspendedLifeCycle() {
            super(4);
        }

        public void execute() throws JADESecurityException, InterruptedException, InterruptedIOException {
            Agent.this.waitUntilActivate();
        }

        public void end() {
            Agent.this.clean(false);
        }

        public boolean transitionTo(LifeCycle lifeCycle) {
            return lifeCycle.getState() == 2 || lifeCycle.getState() == 6;
        }
    }

    private class DeletedLifeCycle
    extends LifeCycle {
        private DeletedLifeCycle() {
            super(6);
        }

        public void end() {
            Agent.this.clean(true);
        }

        public boolean alive() {
            return false;
        }
    }

    private class ActiveLifeCycle
    extends LifeCycle {
        private ActiveLifeCycle() {
            super(1);
        }

        public void setState(int n) {
            this.myState = n;
        }

        public void init() {
            Agent.this.setActiveState(2);
            Agent.this.notifyStarted();
            Agent.this.setup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws JADESecurityException, InterruptedException, InterruptedIOException {
            Behaviour behaviour = Agent.this.myScheduler.schedule();
            int n = Agent.this.messageCounter;
            behaviour.actionWrapper();
            if (n != Agent.this.messageCounter && !behaviour.isRunnable()) {
                behaviour.restart();
            }
            if (behaviour.done()) {
                behaviour.onEnd();
                Agent.this.myScheduler.remove(behaviour);
                behaviour = null;
            } else {
                Scheduler scheduler = Agent.this.myScheduler;
                synchronized (scheduler) {
                    if (!behaviour.isRunnable()) {
                        Agent.this.myScheduler.block(behaviour);
                        behaviour = null;
                    }
                }
            }
        }

        public void end() {
            Agent.this.clean(false);
        }

        public boolean transitionTo(LifeCycle lifeCycle) {
            if (!Agent.this.terminating) {
                this.myState = 2;
                return true;
            }
            return false;
        }

        public void transitionFrom(LifeCycle lifeCycle) {
            Agent.this.activateAllBehaviours();
        }
    }

    private static class CondVar {
        private boolean value = false;

        private CondVar() {
        }

        public synchronized void waitOn() throws InterruptedException {
            while (!this.value) {
                this.wait();
            }
        }

        public synchronized void set() {
            this.value = true;
            this.notifyAll();
        }
    }

    private static class TBPair {
        private Timer myTimer;
        private long expirationTime;
        private Behaviour myBehaviour;
        private Agent owner;

        public TBPair() {
            this.expirationTime = -1L;
        }

        public TBPair(Agent agent, Timer timer, Behaviour behaviour) {
            this.owner = agent;
            this.myTimer = timer;
            this.expirationTime = timer.expirationTime();
            this.myBehaviour = behaviour;
        }

        public void setTimer(Timer timer) {
            this.myTimer = timer;
        }

        public Timer getTimer() {
            return this.myTimer;
        }

        public Behaviour getBehaviour() {
            return this.myBehaviour;
        }

        public void setBehaviour(Behaviour behaviour) {
            this.myBehaviour = behaviour;
        }

        public Agent getOwner() {
            return this.owner;
        }

        public void setOwner(Agent agent) {
            this.owner = agent;
            this.createTimerIfNeeded();
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }

        public void setExpirationTime(long l) {
            this.expirationTime = l;
            this.createTimerIfNeeded();
        }

        private void createTimerIfNeeded() {
            if (this.myTimer == null && this.owner != null && this.expirationTime > 0L) {
                this.myTimer = new Timer(this.expirationTime, this.owner);
            }
        }
    }

    private class AssociationTB {
        private Hashtable BtoT = new Hashtable();
        private Hashtable TtoB = new Hashtable();

        private AssociationTB() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            TimerDispatcher timerDispatcher = Agent.this.theDispatcher;
            synchronized (timerDispatcher) {
                Enumeration enumeration = this.timers();
                while (enumeration.hasMoreElements()) {
                    Timer timer = (Timer)enumeration.nextElement();
                    Agent.this.theDispatcher.remove(timer);
                }
                this.BtoT.clear();
                this.TtoB.clear();
                Agent.this.persistentPendingTimers.clear();
            }
        }

        public void addPair(Behaviour behaviour, Timer timer) {
            TBPair tBPair = new TBPair(Agent.this, timer, behaviour);
            this.addPair(tBPair);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPair(TBPair tBPair) {
            TimerDispatcher timerDispatcher = Agent.this.theDispatcher;
            synchronized (timerDispatcher) {
                if (tBPair.getOwner() == null) {
                    tBPair.setOwner(Agent.this);
                }
                tBPair.setTimer(Agent.this.theDispatcher.add(tBPair.getTimer()));
                TBPair tBPair2 = this.BtoT.put(tBPair.getBehaviour(), tBPair);
                if (tBPair2 != null) {
                    Agent.this.theDispatcher.remove(tBPair2.getTimer());
                    Agent.this.persistentPendingTimers.remove(tBPair2);
                    this.TtoB.remove(tBPair2.getTimer());
                }
                this.TtoB.put(tBPair.getTimer(), tBPair);
                Agent.this.persistentPendingTimers.add(tBPair);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeMapping(Behaviour behaviour) {
            TimerDispatcher timerDispatcher = Agent.this.theDispatcher;
            synchronized (timerDispatcher) {
                TBPair tBPair = (TBPair)this.BtoT.remove(behaviour);
                if (tBPair != null) {
                    this.TtoB.remove(tBPair.getTimer());
                    Agent.this.persistentPendingTimers.remove(tBPair);
                    Agent.this.theDispatcher.remove(tBPair.getTimer());
                }
            }
        }

        public Timer getPeer(Behaviour behaviour) {
            TBPair tBPair = (TBPair)this.BtoT.get(behaviour);
            if (tBPair != null) {
                return tBPair.getTimer();
            }
            return null;
        }

        public Behaviour getPeer(Timer timer) {
            TBPair tBPair = (TBPair)this.TtoB.get(timer);
            if (tBPair != null) {
                return tBPair.getBehaviour();
            }
            return null;
        }

        private Enumeration timers() {
            return this.TtoB.keys();
        }
    }

    public static class Interrupted
    extends Error {
    }
}

