/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.CaseInsensitiveString;
import jade.core.Location;
import jade.mtp.TransportAddress;

public class ContainerID
implements Location {
    public static final String DEFAULT_IMTP = "JADE-IMTP";
    private String name;
    private String address;

    public ContainerID() {
    }

    public ContainerID(String string, TransportAddress transportAddress) {
        this.name = string;
        this.address = transportAddress != null ? transportAddress.getHost() : "<Unknown Host>";
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setProtocol(String string) {
    }

    public String getProtocol() {
        return DEFAULT_IMTP;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public String getAddress() {
        return this.address;
    }

    public String getID() {
        return this.name + '@' + DEFAULT_IMTP + "://" + this.address;
    }

    public String toString() {
        return this.getID();
    }

    public boolean equals(Object object) {
        try {
            ContainerID containerID = (ContainerID)object;
            return CaseInsensitiveString.equalsIgnoreCase(this.name, containerID.getName());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.name.toLowerCase().hashCode();
    }
}

