/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.lang.acl.ACLMessage;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import java.util.List;

class MessageQueue {
    private LinkedList list;
    private int maxSize;
    private Long persistentID;

    public MessageQueue(int n) {
        this.maxSize = n;
        this.list = new LinkedList();
    }

    public MessageQueue() {
        this(0);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void setMaxSize(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid MsgQueue size");
        }
        this.maxSize = n;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int size() {
        return this.list.size();
    }

    public void addFirst(ACLMessage aCLMessage) {
        if (this.maxSize != 0 && this.list.size() >= this.maxSize) {
            this.list.removeFirst();
        }
        this.list.addFirst(aCLMessage);
    }

    public void addLast(ACLMessage aCLMessage) {
        if (this.maxSize != 0 && this.list.size() >= this.maxSize) {
            this.list.removeFirst();
            System.err.println("WARNING: a message has been lost by an agent because of the FIFO replacement policy of its message queue.\n Notice that, under some circumstances, this might not be the proper expected behaviour and the size of the queue needs to be increased. Check the method Agent.setQueueSize()");
        }
        this.list.addLast(aCLMessage);
    }

    public ACLMessage removeFirst() {
        return (ACLMessage)this.list.removeFirst();
    }

    public boolean remove(ACLMessage aCLMessage) {
        return this.list.remove(aCLMessage);
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    private void setMessages(List list) {
        System.out.println(">>> MessageQueue::setMessages() <<<");
    }

    private List getMessages() {
        System.out.println(">>> MessageQueue::getMessages() <<<");
        return null;
    }

    private Long getPersistentID() {
        return this.persistentID;
    }

    private void setPersistentID(Long l) {
        this.persistentID = l;
    }
}

