/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.CaseInsensitiveString;
import jade.core.CommandProcessor;
import jade.core.ContainerID;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.MainContainerImpl;
import jade.core.Node;
import jade.core.NodeDescriptor;
import jade.core.NodeEventListener;
import jade.core.NodeFailureMonitor;
import jade.core.PlatformManager;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceDescriptor;
import jade.core.ServiceException;
import jade.core.VerticalCommand;
import jade.core.behaviours.Behaviour;
import jade.mtp.TransportAddress;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;
import jade.util.leap.Serializable;
import java.util.Vector;

public class PlatformManagerImpl
implements PlatformManager {
    private IMTPManager myIMTPManager;
    private CommandProcessor myCommandProcessor;
    private MainContainerImpl myMain;
    private Map nodes;
    private Map services;
    private Map replicas;
    private Map monitors;
    private String localAddr;
    private String platformID;
    private int containerNo = 1;
    private int mainContainerNo = 0;
    private int nodeNo = 1;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private Profile myProfile;

    PlatformManagerImpl(Profile profile) throws ProfileException {
        this.myCommandProcessor = profile.getCommandProcessor();
        this.myIMTPManager = profile.getIMTPManager();
        this.myMain = new MainContainerImpl(profile, this);
        this.myProfile = profile;
        this.nodes = new HashMap();
        this.services = new HashMap();
        this.replicas = new HashMap();
        this.monitors = new HashMap();
        this.platformID = profile.getParameter("platform-id", null);
        if (this.platformID == null || this.platformID.equals("")) {
            try {
                List list = this.myIMTPManager.getLocalAddresses();
                TransportAddress transportAddress = (TransportAddress)list.get(0);
                this.platformID = transportAddress.getHost() + ":" + transportAddress.getPort() + "/JADE";
            }
            catch (Exception exception) {
                throw new ProfileException("Can't set PlatformID");
            }
        }
    }

    MainContainerImpl getMain() {
        return this.myMain;
    }

    public void setPlatformName(String string) throws IMTPException {
        this.platformID = string;
    }

    public String getPlatformName() throws IMTPException {
        return this.platformID;
    }

    public String getLocalAddress() {
        return this.localAddr;
    }

    public void setLocalAddress(String string) {
        this.localAddr = string;
    }

    public String addNode(NodeDescriptor nodeDescriptor, Vector vector, boolean bl) throws IMTPException, ServiceException, JADESecurityException {
        String string = this.localAddNode(nodeDescriptor, vector, bl);
        if (!bl) {
            this.broadcastAddNode(nodeDescriptor, vector);
        }
        return string;
    }

    private String localAddNode(NodeDescriptor nodeDescriptor, Vector vector, boolean bl) throws IMTPException, ServiceException, JADESecurityException {
        Object object;
        Node node = nodeDescriptor.getNode();
        this.adjustName(nodeDescriptor, node);
        if (!bl) {
            GenericCommand genericCommand = new GenericCommand("New-Node", null, null);
            genericCommand.addParam(nodeDescriptor);
            object = this.myCommandProcessor.processIncoming(genericCommand);
            if (object instanceof JADESecurityException) {
                throw (JADESecurityException)object;
            }
            if (object instanceof Throwable) {
                this.myLogger.log(Logger.SEVERE, "Unexpected error processing NEW_NODE command. Node is " + nodeDescriptor.getName());
                ((Throwable)object).printStackTrace();
            }
        }
        if (this.isLocalNode(node)) {
            this.myMain.addLocalContainer(nodeDescriptor.getContainer());
        } else {
            if (this.myLogger.isLoggable(Logger.INFO)) {
                this.myLogger.log(Logger.INFO, "Adding node <" + nodeDescriptor.getName() + "> to the platform");
            }
            if (nodeDescriptor.getContainer() != null) {
                this.myMain.addRemoteContainer(nodeDescriptor.getContainer());
            }
            if (!bl) {
                NodeFailureMonitor nodeFailureMonitor;
                boolean bl2 = true;
                object = nodeDescriptor.getParentNode();
                if (object != null && (nodeFailureMonitor = (NodeFailureMonitor)this.monitors.get(object.getName())) != null) {
                    nodeFailureMonitor.addChild(node);
                    bl2 = false;
                }
                if (bl2) {
                    this.monitor(node);
                }
            }
        }
        this.nodes.put(nodeDescriptor.getName(), nodeDescriptor);
        int n = 0;
        while (n < vector.size()) {
            object = (ServiceDescriptor)vector.elementAt(n);
            this.localAddSlice((ServiceDescriptor)object, nodeDescriptor, bl);
            ++n;
        }
        return node.getName();
    }

    private void broadcastAddNode(NodeDescriptor nodeDescriptor, Vector vector) throws IMTPException, ServiceException {
        Object[] objectArray = this.replicas.values().toArray();
        int n = 0;
        while (n < objectArray.length) {
            PlatformManager platformManager = (PlatformManager)objectArray[n];
            try {
                platformManager.addNode(nodeDescriptor, vector, true);
            }
            catch (IMTPException iMTPException) {
                this.localRemoveReplica(platformManager.getLocalAddress(), true);
            }
            catch (JADESecurityException jADESecurityException) {
                jADESecurityException.printStackTrace();
            }
            ++n;
        }
    }

    public void removeNode(NodeDescriptor nodeDescriptor, boolean bl) throws IMTPException, ServiceException {
        this.localRemoveNode(nodeDescriptor, bl);
        if (!bl && !this.isLocalNode(nodeDescriptor.getNode())) {
            this.broadcastRemoveNode(nodeDescriptor);
        }
    }

    private void localRemoveNode(NodeDescriptor nodeDescriptor, boolean bl) throws IMTPException, ServiceException {
        Object object;
        Object object2;
        nodeDescriptor = this.adjustDescriptor(nodeDescriptor);
        Node node = nodeDescriptor.getNode();
        Object[] objectArray = this.services.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            object2 = (String)objectArray[n];
            this.localRemoveSlice((String)object2, nodeDescriptor.getName(), bl);
            ++n;
        }
        if (this.isLocalNode(node)) {
            this.myMain.removeLocalContainer(nodeDescriptor.getContainer());
        } else {
            if (this.myLogger.isLoggable(Logger.INFO)) {
                this.myLogger.log(Logger.INFO, "Removing node <" + nodeDescriptor.getName() + "> from the platform");
            }
            if (nodeDescriptor.getContainer() != null) {
                this.myMain.removeRemoteContainer(nodeDescriptor.getContainer());
            }
        }
        this.nodes.remove(nodeDescriptor.getName());
        object2 = nodeDescriptor.getParentNode();
        if (object2 != null && (object = (NodeFailureMonitor)this.monitors.get(object2.getName())) != null) {
            ((NodeFailureMonitor)object).removeChild(node);
        }
        this.monitors.remove(node.getName());
        if (!bl) {
            object = new GenericCommand("Dead-Node", null, null);
            ((GenericCommand)object).addParam(nodeDescriptor);
            Object object3 = this.myCommandProcessor.processIncoming((VerticalCommand)object);
            if (object3 instanceof Throwable) {
                this.myLogger.log(Logger.SEVERE, "Unexpected error processing DEAD_NODE command. Node is " + nodeDescriptor.getName());
                ((Throwable)object3).printStackTrace();
            }
        }
    }

    private void broadcastRemoveNode(NodeDescriptor nodeDescriptor) throws IMTPException, ServiceException {
        Object[] objectArray = this.replicas.values().toArray();
        int n = 0;
        while (n < objectArray.length) {
            PlatformManager platformManager = (PlatformManager)objectArray[n];
            try {
                platformManager.removeNode(nodeDescriptor, true);
            }
            catch (IMTPException iMTPException) {
                this.localRemoveReplica(platformManager.getLocalAddress(), true);
            }
            ++n;
        }
    }

    public void addSlice(ServiceDescriptor serviceDescriptor, NodeDescriptor nodeDescriptor, boolean bl) throws IMTPException, ServiceException {
        this.localAddSlice(serviceDescriptor, nodeDescriptor, bl);
        if (!bl) {
            this.broadcastAddSlice(serviceDescriptor, nodeDescriptor);
        }
    }

    private void localAddSlice(ServiceDescriptor serviceDescriptor, NodeDescriptor nodeDescriptor, boolean bl) throws IMTPException, ServiceException {
        Serializable serializable;
        Service service = serviceDescriptor.getService();
        String string = service.getName();
        ServiceEntry serviceEntry = (ServiceEntry)this.services.get(string);
        if (serviceEntry == null) {
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Adding entry for service <" + string + ">");
            }
            serviceEntry = new ServiceEntry(service);
            this.services.put(string, serviceEntry);
        }
        if (this.myLogger.isLoggable(Logger.CONFIG)) {
            this.myLogger.log(Logger.CONFIG, "Adding slice for service <" + string + "> on node <" + nodeDescriptor.getName() + ">");
        }
        Node node = nodeDescriptor.getNode();
        Service.Slice slice = null;
        slice = service.getHorizontalInterface() != null ? this.myIMTPManager.createSliceProxy(string, service.getHorizontalInterface(), node) : new Service.SliceProxy(service, node);
        String string2 = node.getName();
        serviceEntry.addSlice(string2, slice, node);
        if (this.isLocalNode(node) && (serializable = service.getAMSBehaviour()) != null) {
            this.myMain.installAMSBehaviour((Behaviour)serializable);
        }
        if (!bl) {
            serializable = new GenericCommand("New-Slice", string, null);
            ((GenericCommand)serializable).addParam(string2);
            Object object = this.myCommandProcessor.processIncoming((VerticalCommand)((Object)serializable));
            if (object instanceof Throwable) {
                this.myLogger.log(Logger.SEVERE, "Unexpected error processing NEW_SLICE command. Service is " + string + " node is " + string2);
                ((Throwable)object).printStackTrace();
            }
        }
    }

    private void broadcastAddSlice(ServiceDescriptor serviceDescriptor, NodeDescriptor nodeDescriptor) throws IMTPException, ServiceException {
        Object[] objectArray = this.replicas.values().toArray();
        int n = 0;
        while (n < objectArray.length) {
            PlatformManager platformManager = (PlatformManager)objectArray[n];
            try {
                platformManager.addSlice(serviceDescriptor, nodeDescriptor, true);
            }
            catch (IMTPException iMTPException) {
                this.localRemoveReplica(platformManager.getLocalAddress(), true);
            }
            ++n;
        }
    }

    public void removeSlice(String string, String string2, boolean bl) throws IMTPException, ServiceException {
        this.localRemoveSlice(string, string2, bl);
        if (!bl) {
            this.broadcastRemoveSlice(string, string2);
        }
    }

    private void localRemoveSlice(String string, String string2, boolean bl) throws IMTPException, ServiceException {
        ServiceEntry serviceEntry = (ServiceEntry)this.services.get(string);
        if (serviceEntry != null) {
            Serializable serializable;
            NodeDescriptor nodeDescriptor;
            if (serviceEntry.removeSlice(string2) != null && this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "Removing slice for service <" + string + "> on node <" + string2 + ">");
            }
            if ((nodeDescriptor = this.getDescriptor(string2)) != null && this.isLocalNode(nodeDescriptor.getNode()) && (serializable = serviceEntry.getService().getAMSBehaviour()) != null) {
                this.myMain.uninstallAMSBehaviour((Behaviour)serializable);
            }
            if (!bl) {
                serializable = new GenericCommand("Dead-Slice", string, null);
                ((GenericCommand)serializable).addParam(string2);
                Object object = this.myCommandProcessor.processIncoming((VerticalCommand)((Object)serializable));
                if (object instanceof Throwable) {
                    this.myLogger.log(Logger.SEVERE, "Unexpected error processing DEAD_SLICE command. Service is " + string + " node is " + string2);
                    ((Throwable)object).printStackTrace();
                }
            }
        }
    }

    private void broadcastRemoveSlice(String string, String string2) throws IMTPException, ServiceException {
        Object[] objectArray = this.replicas.values().toArray();
        int n = 0;
        while (n < objectArray.length) {
            PlatformManager platformManager = (PlatformManager)objectArray[n];
            platformManager.removeSlice(string, string2, true);
            try {
                platformManager.removeSlice(string, string2, true);
            }
            catch (IMTPException iMTPException) {
                this.localRemoveReplica(platformManager.getLocalAddress(), true);
            }
            ++n;
        }
    }

    public void addReplica(String string, boolean bl) throws IMTPException, ServiceException {
        PlatformManager platformManager = this.myIMTPManager.getPlatformManagerProxy(string);
        this.localAddReplica(platformManager, bl);
        if (!bl) {
            this.broadcastAddReplica(string);
        }
        this.replicas.put(platformManager.getLocalAddress(), platformManager);
    }

    private void localAddReplica(PlatformManager platformManager, boolean bl) throws IMTPException, ServiceException {
        if (this.myLogger.isLoggable(Logger.INFO)) {
            this.myLogger.log(Logger.INFO, "Adding replica <" + platformManager.getLocalAddress() + "> to the platform");
        }
        if (!bl) {
            Object object;
            Object[] objectArray;
            List list = this.getAllNodesInfo();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                objectArray = (Object[])iterator.next();
                try {
                    platformManager.addNode(objectArray.getNodeDescriptor(), objectArray.getServices(), true);
                }
                catch (JADESecurityException jADESecurityException) {
                    jADESecurityException.printStackTrace();
                }
            }
            objectArray = this.replicas.values().toArray();
            int n = 0;
            while (n < objectArray.length) {
                object = (PlatformManager)objectArray[n];
                platformManager.addReplica(object.getLocalAddress(), true);
                ++n;
            }
            object = new GenericCommand("New-Replica", null, null);
            ((GenericCommand)object).addParam(platformManager.getLocalAddress());
            Object object2 = this.myCommandProcessor.processIncoming((VerticalCommand)object);
            if (object2 instanceof Throwable) {
                this.myLogger.log(Logger.SEVERE, "Unexpected error processing NEW_REPLICA command. Replica address is " + platformManager.getLocalAddress());
                ((Throwable)object2).printStackTrace();
            }
        }
    }

    private void broadcastAddReplica(String string) throws IMTPException, ServiceException {
        Object[] objectArray = this.replicas.values().toArray();
        int n = 0;
        while (n < objectArray.length) {
            PlatformManager platformManager = (PlatformManager)objectArray[n];
            try {
                platformManager.addReplica(string, true);
            }
            catch (IMTPException iMTPException) {
                this.localRemoveReplica(platformManager.getLocalAddress(), true);
            }
            ++n;
        }
    }

    public void removeReplica(String string, boolean bl) throws IMTPException, ServiceException {
        this.localRemoveReplica(string, bl);
        if (!bl) {
            this.broadcastRemoveReplica(string);
        }
    }

    private void localRemoveReplica(String string, boolean bl) throws IMTPException, ServiceException {
        if (this.myLogger.isLoggable(Logger.INFO)) {
            this.myLogger.log(Logger.INFO, "Removing replica <" + string + "> from the platform");
        }
        this.replicas.remove(string);
        if (!bl) {
            Object object;
            Serializable serializable;
            Object[] objectArray = this.nodes.values().toArray();
            int n = 0;
            while (n < objectArray.length) {
                serializable = (NodeDescriptor)objectArray[n];
                if (((NodeDescriptor)serializable).getParentNode() == null && !(object = ((NodeDescriptor)serializable).getNode()).hasPlatformManager()) {
                    try {
                        object.platformManagerDead(string, this.getLocalAddress());
                    }
                    catch (IMTPException iMTPException) {
                        this.removeTerminatedNode((Node)object);
                    }
                }
                ++n;
            }
            serializable = new GenericCommand("Dead-Replica", null, null);
            ((GenericCommand)serializable).addParam(string);
            object = this.myCommandProcessor.processIncoming((VerticalCommand)((Object)serializable));
            if (object instanceof Throwable) {
                this.myLogger.log(Logger.SEVERE, "Unexpected error processing DEAD_REPLICA command. Replica address is " + string);
                ((Throwable)object).printStackTrace();
            }
        }
    }

    private void broadcastRemoveReplica(String string) throws IMTPException, ServiceException {
        Object[] objectArray = this.replicas.values().toArray();
        int n = 0;
        while (n < objectArray.length) {
            PlatformManager platformManager = (PlatformManager)objectArray[n];
            try {
                platformManager.removeReplica(string, true);
            }
            catch (IMTPException iMTPException) {
                this.localRemoveReplica(platformManager.getLocalAddress(), true);
            }
            ++n;
        }
    }

    public void adopt(Node node, Node[] nodeArray) throws IMTPException {
        NodeFailureMonitor nodeFailureMonitor = this.monitor(node);
        if (nodeArray != null) {
            int n = 0;
            while (n < nodeArray.length) {
                nodeFailureMonitor.addChild(nodeArray[n]);
                ++n;
            }
        }
    }

    public void ping() throws IMTPException {
    }

    public Service.Slice findSlice(String string, String string2) throws IMTPException, ServiceException {
        ServiceEntry serviceEntry = (ServiceEntry)this.services.get(string);
        if (serviceEntry == null) {
            return null;
        }
        if (CaseInsensitiveString.equalsIgnoreCase(string2, "$$$Main-Slice$$$")) {
            string2 = this.myIMTPManager.getLocalNode().getName();
        }
        return serviceEntry.getSlice(string2);
    }

    public Vector findAllSlices(String string) throws IMTPException, ServiceException {
        ServiceEntry serviceEntry = (ServiceEntry)this.services.get(string);
        if (serviceEntry == null) {
            return null;
        }
        return serviceEntry.getSlices();
    }

    NodeDescriptor getDescriptor(String string) {
        return (NodeDescriptor)this.nodes.get(string);
    }

    void shutdown() {
    }

    private boolean isLocalNode(Node node) {
        try {
            return this.myIMTPManager.getLocalNode().equals(node);
        }
        catch (IMTPException iMTPException) {
            iMTPException.printStackTrace();
            return false;
        }
    }

    private NodeDescriptor adjustDescriptor(NodeDescriptor nodeDescriptor) {
        NodeDescriptor nodeDescriptor2 = (NodeDescriptor)this.nodes.get(nodeDescriptor.getName());
        if (nodeDescriptor2 != null) {
            ContainerID containerID = nodeDescriptor2.getContainer();
            if (containerID != null) {
                nodeDescriptor = new NodeDescriptor(containerID, nodeDescriptor.getNode());
            }
            nodeDescriptor.setParentNode(nodeDescriptor2.getParentNode());
        }
        return nodeDescriptor;
    }

    private List getAllNodesInfo() {
        Object object;
        Object object2;
        Serializable serializable;
        Object[] objectArray = this.nodes.values().toArray();
        ArrayList arrayList = new ArrayList(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            serializable = (NodeDescriptor)objectArray[n];
            arrayList.add(new NodeInfo((NodeDescriptor)serializable));
            ++n;
        }
        serializable = new HashMap();
        Object[] objectArray2 = this.services.values().toArray();
        int n2 = 0;
        while (n2 < objectArray2.length) {
            object2 = (ServiceEntry)objectArray2[n2];
            object = ((ServiceEntry)object2).getNodes();
            int n3 = 0;
            while (n3 < ((Object)object).length) {
                String string = object[n3].getName();
                Vector<ServiceDescriptor> vector = (Vector<ServiceDescriptor>)serializable.get(string);
                if (vector == null) {
                    vector = new Vector<ServiceDescriptor>();
                    serializable.put(string, vector);
                }
                Service service = ((ServiceEntry)object2).getService();
                vector.addElement(new ServiceDescriptor(service.getName(), service));
                ++n3;
            }
            ++n2;
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (NodeInfo)object2.next();
            Vector vector = (Vector)serializable.get(((NodeInfo)object).getNodeDescriptor().getName());
            ((NodeInfo)object).setServices(vector);
        }
        return arrayList;
    }

    private void adjustName(NodeDescriptor nodeDescriptor, Node node) {
        ContainerID containerID = nodeDescriptor.getContainer();
        if (containerID != null) {
            this.adjustContainerName(node, containerID);
            node.setName(containerID.getName());
            nodeDescriptor.setName(containerID.getName());
        } else {
            if (node.getName() == null || node.getName().equals("No-Name")) {
                String string = null;
                NodeDescriptor nodeDescriptor2 = null;
                do {
                    string = "Aux-Node-" + this.nodeNo;
                    ++this.nodeNo;
                } while ((nodeDescriptor2 = (NodeDescriptor)this.nodes.get(string)) != null);
                node.setName(string);
            }
            nodeDescriptor.setName(node.getName());
        }
    }

    private void adjustContainerName(Node node, ContainerID containerID) {
        String string = null;
        NodeDescriptor nodeDescriptor = null;
        if (containerID.getName() == null || containerID.getName().equals("No-Name")) {
            if (node.hasPlatformManager()) {
                do {
                    string = "Main-Container" + (this.mainContainerNo == 0 ? "" : "-" + this.mainContainerNo);
                    ++this.mainContainerNo;
                } while ((nodeDescriptor = (NodeDescriptor)this.nodes.get(string)) != null);
            } else {
                do {
                    string = "Container-" + this.containerNo;
                    ++this.containerNo;
                } while ((nodeDescriptor = (NodeDescriptor)this.nodes.get(string)) != null);
            }
            containerID.setName(string);
        } else {
            string = containerID.getName();
            int n = 1;
            nodeDescriptor = (NodeDescriptor)this.nodes.get(string);
            while (nodeDescriptor != null) {
                string = containerID.getName() + '-' + n;
                ++n;
                nodeDescriptor = (NodeDescriptor)this.nodes.get(string);
            }
            containerID.setName(string);
        }
    }

    private NodeFailureMonitor monitor(Node node) {
        NodeEventListener nodeEventListener = new NodeEventListener(){

            public void nodeAdded(Node node) {
                if (PlatformManagerImpl.this.myLogger.isLoggable(Logger.INFO)) {
                    PlatformManagerImpl.this.myLogger.log(Logger.INFO, "--- Node <" + node.getName() + "> ALIVE ---");
                }
            }

            public void nodeRemoved(Node node) {
                PlatformManagerImpl.this.removeTerminatedNode(node);
            }

            public void nodeUnreachable(Node node) {
                if (PlatformManagerImpl.this.myLogger.isLoggable(Logger.WARNING)) {
                    PlatformManagerImpl.this.myLogger.log(Logger.WARNING, "--- Node <" + node.getName() + "> UNREACHABLE ---");
                }
            }

            public void nodeReachable(Node node) {
                if (PlatformManagerImpl.this.myLogger.isLoggable(Logger.INFO)) {
                    PlatformManagerImpl.this.myLogger.log(Logger.INFO, "--- Node <" + node.getName() + "> REACHABLE ---");
                }
            }
        };
        NodeFailureMonitor nodeFailureMonitor = NodeFailureMonitor.getFailureMonitor();
        nodeFailureMonitor.start(node, nodeEventListener);
        return nodeFailureMonitor;
    }

    private void removeTerminatedNode(Node node) {
        if (this.myLogger.isLoggable(Logger.INFO)) {
            this.myLogger.log(Logger.INFO, "--- Node <" + node.getName() + "> TERMINATED ---");
        }
        try {
            this.removeNode(new NodeDescriptor(node), false);
        }
        catch (IMTPException iMTPException) {
            iMTPException.printStackTrace();
        }
        catch (ServiceException serviceException) {
            serviceException.printStackTrace();
        }
    }

    private class NodeInfo {
        private NodeDescriptor nodeDsc;
        private Vector services;

        private NodeInfo(NodeDescriptor nodeDescriptor) {
            this.nodeDsc = nodeDescriptor;
        }

        public NodeDescriptor getNodeDescriptor() {
            return this.nodeDsc;
        }

        public Vector getServices() {
            return this.services;
        }

        public void setServices(Vector vector) {
            this.services = vector;
        }
    }

    private class SliceEntry {
        private Service.Slice mySlice;
        private Node myNode;

        public SliceEntry(Service.Slice slice, Node node) {
            this.mySlice = slice;
            this.myNode = node;
        }

        public Service.Slice getSlice() {
            return this.mySlice;
        }

        public Node getNode() {
            return this.myNode;
        }
    }

    private class ServiceEntry {
        private Service myService;
        private Map slices;

        public ServiceEntry(Service service) {
            this.myService = service;
            this.slices = new HashMap();
        }

        public void addSlice(String string, Service.Slice slice, Node node) {
            SliceEntry sliceEntry = new SliceEntry(slice, node);
            this.slices.put(string, sliceEntry);
        }

        public Service.Slice removeSlice(String string) {
            SliceEntry sliceEntry = (SliceEntry)this.slices.remove(string);
            if (sliceEntry == null) {
                return null;
            }
            return sliceEntry.getSlice();
        }

        public Vector getSlices() {
            Iterator iterator = this.slices.values().iterator();
            Vector<Service.Slice> vector = new Vector<Service.Slice>();
            while (iterator.hasNext()) {
                SliceEntry sliceEntry = (SliceEntry)iterator.next();
                vector.addElement(sliceEntry.getSlice());
            }
            return vector;
        }

        public Service.Slice getSlice(String string) {
            SliceEntry sliceEntry = (SliceEntry)this.slices.get(string);
            if (sliceEntry == null) {
                return null;
            }
            return sliceEntry.getSlice();
        }

        public Node[] getNodes() {
            Object[] objectArray = this.slices.values().toArray();
            Node[] nodeArray = new Node[objectArray.length];
            int n = 0;
            while (n < nodeArray.length) {
                SliceEntry sliceEntry = (SliceEntry)objectArray[n];
                nodeArray[n] = sliceEntry.getNode();
                ++n;
            }
            return nodeArray;
        }

        public Node getNode(String string) {
            SliceEntry sliceEntry = (SliceEntry)this.slices.get(string);
            if (sliceEntry == null) {
                return null;
            }
            return sliceEntry.getNode();
        }

        public void setService(Service service) {
            this.myService = service;
        }

        public Service getService() {
            return this.myService;
        }
    }
}

