/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.util.leap.Collection;
import jade.util.leap.Iterator;

public abstract class CompositeBehaviour
extends Behaviour {
    private boolean starting = true;
    private boolean finished = false;
    private boolean currentDone;
    private int currentResult;
    protected boolean currentExecuted;

    protected CompositeBehaviour() {
    }

    protected CompositeBehaviour(Agent agent) {
        super(agent);
    }

    public final void action() {
        if (this.starting) {
            this.scheduleFirst();
            this.starting = false;
        } else if (this.currentExecuted) {
            this.scheduleNext(this.currentDone, this.currentResult);
        }
        this.currentExecuted = false;
        Behaviour behaviour = this.getCurrent();
        this.currentDone = false;
        this.currentResult = 0;
        if (behaviour != null) {
            if (behaviour.isRunnable()) {
                behaviour.actionWrapper();
                this.currentExecuted = true;
                if (behaviour.done()) {
                    this.currentDone = true;
                    this.currentResult = behaviour.onEnd();
                }
                this.finished = this.checkTermination(this.currentDone, this.currentResult);
            } else {
                this.myEvent.init(false, -1);
                super.handle(this.myEvent);
            }
        } else {
            this.finished = true;
        }
    }

    public final boolean done() {
        return this.finished;
    }

    protected abstract void scheduleFirst();

    protected abstract void scheduleNext(boolean var1, int var2);

    protected abstract boolean checkTermination(boolean var1, int var2);

    protected abstract Behaviour getCurrent();

    public abstract Collection getChildren();

    public void block() {
        super.block();
        this.myEvent.init(false, 1);
        this.handle(this.myEvent);
    }

    public void restart() {
        this.myEvent.init(true, 1);
        this.handle(this.myEvent);
        super.restart();
    }

    public void reset() {
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            Behaviour behaviour = (Behaviour)iterator.next();
            behaviour.reset();
        }
        this.starting = true;
        this.finished = false;
        super.reset();
    }

    public void setAgent(Agent agent) {
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            Behaviour behaviour = (Behaviour)iterator.next();
            behaviour.setAgent(agent);
        }
        super.setAgent(agent);
    }

    protected void registerAsChild(Behaviour behaviour) {
        behaviour.setParent(this);
    }
}

