/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.SerialBehaviour;
import jade.util.leap.ArrayList;
import jade.util.leap.Collection;
import jade.util.leap.List;

public class SequentialBehaviour
extends SerialBehaviour {
    private List subBehaviours = new ArrayList();
    int current = 0;

    public SequentialBehaviour() {
    }

    public SequentialBehaviour(Agent agent) {
        super(agent);
    }

    protected void scheduleFirst() {
        this.current = 0;
    }

    protected void scheduleNext(boolean bl, int n) {
        if (bl) {
            ++this.current;
        }
    }

    protected boolean checkTermination(boolean bl, int n) {
        return bl && this.current >= this.subBehaviours.size() - 1;
    }

    protected Behaviour getCurrent() {
        Behaviour behaviour = null;
        if (this.subBehaviours.size() > this.current) {
            behaviour = (Behaviour)this.subBehaviours.get(this.current);
        }
        return behaviour;
    }

    public Collection getChildren() {
        return this.subBehaviours;
    }

    public void addSubBehaviour(Behaviour behaviour) {
        this.subBehaviours.add(behaviour);
        behaviour.setParent(this);
        behaviour.setAgent(this.myAgent);
    }

    public void removeSubBehaviour(Behaviour behaviour) {
        boolean bl = this.subBehaviours.remove(behaviour);
        if (bl) {
            behaviour.setParent(null);
        }
    }

    public void skipNext() {
        this.current = this.subBehaviours.size();
    }

    private Behaviour[] getSubBehaviours() {
        Object[] objectArray = this.subBehaviours.toArray();
        Behaviour[] behaviourArray = new Behaviour[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            behaviourArray[n] = (Behaviour)objectArray[n];
            ++n;
        }
        return behaviourArray;
    }

    private void setSubBehaviours(Behaviour[] behaviourArray) {
        this.subBehaviours.clear();
        int n = 0;
        while (n < behaviourArray.length) {
            this.subBehaviours.add(behaviourArray[n]);
            ++n;
        }
    }

    private int getCurrentIndex() {
        return this.current;
    }

    private void setCurrentIndex(int n) {
        this.current = n;
    }
}

