/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CompositeBehaviour;
import jade.core.behaviours.DataStore;
import jade.util.leap.Collection;
import java.util.Enumeration;
import java.util.Vector;

public class ThreadedBehaviourFactory {
    private Vector threadedBehaviours = new Vector();

    public Behaviour wrap(Behaviour behaviour) {
        return new ThreadedBehaviour(behaviour);
    }

    public int size() {
        return this.threadedBehaviours.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Vector vector = this.threadedBehaviours;
        synchronized (vector) {
            ThreadedBehaviour[] threadedBehaviourArray = new ThreadedBehaviour[this.threadedBehaviours.size()];
            int n = 0;
            while (n < threadedBehaviourArray.length) {
                threadedBehaviourArray[n] = (ThreadedBehaviour)this.threadedBehaviours.elementAt(n);
                ++n;
            }
            int n2 = 0;
            while (n2 < threadedBehaviourArray.length) {
                threadedBehaviourArray[n2].interrupt();
                ++n2;
            }
        }
    }

    public synchronized boolean waitUntilEmpty(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        try {
            while (!this.threadedBehaviours.isEmpty()) {
                if (l <= 0L || l2 < l3) {
                    this.wait(l3 - l2);
                    l2 = System.currentTimeMillis();
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {}
        return this.threadedBehaviours.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread(Behaviour behaviour) {
        Vector vector = this.threadedBehaviours;
        synchronized (vector) {
            Enumeration enumeration = this.threadedBehaviours.elements();
            while (enumeration.hasMoreElements()) {
                ThreadedBehaviour threadedBehaviour = (ThreadedBehaviour)enumeration.nextElement();
                if (!threadedBehaviour.getBehaviour().equals(behaviour)) continue;
                return threadedBehaviour.getThread();
            }
            return null;
        }
    }

    private class DummyCompositeBehaviour
    extends CompositeBehaviour {
        private ThreadedBehaviour myChild;

        private DummyCompositeBehaviour(Agent agent, ThreadedBehaviour threadedBehaviour) {
            super(agent);
            this.myChild = threadedBehaviour;
        }

        public boolean isRunnable() {
            return false;
        }

        protected void handle(Behaviour.RunnableChangedEvent runnableChangedEvent) {
            if (runnableChangedEvent.isRunnable()) {
                this.myChild.go();
            }
        }

        public Behaviour root() {
            Behaviour behaviour = this.myChild.root();
            if (behaviour == this.myChild) {
                return this.myChild.getBehaviour();
            }
            return behaviour;
        }

        protected void scheduleFirst() {
        }

        protected void scheduleNext(boolean bl, int n) {
        }

        protected boolean checkTermination(boolean bl, int n) {
            return false;
        }

        protected Behaviour getCurrent() {
            return null;
        }

        public Collection getChildren() {
            return null;
        }
    }

    private class ThreadedBehaviour
    extends Behaviour
    implements Runnable {
        private Thread myThread;
        private Behaviour myBehaviour;
        private boolean restarted = false;
        private boolean finished = false;
        private int exitValue;

        private ThreadedBehaviour(Behaviour behaviour) {
            super(behaviour.myAgent);
            this.myBehaviour = behaviour;
        }

        public void onStart() {
            this.myBehaviour.setAgent(this.myAgent);
            this.myBehaviour.setParent(new DummyCompositeBehaviour(this.myAgent, this));
            this.myThread = new Thread(this);
            this.myThread.setName(this.myAgent.getLocalName() + "#" + this.myBehaviour.getBehaviourName());
            this.myThread.start();
        }

        public void action() {
            if (!this.finished) {
                this.block();
            }
        }

        public boolean done() {
            return this.finished;
        }

        public int onEnd() {
            if (!this.myBehaviour.isRunnable()) {
                this.block();
            }
            return this.exitValue;
        }

        public void setDataStore(DataStore dataStore) {
            this.myBehaviour.setDataStore(dataStore);
        }

        public DataStore getDataStore() {
            return this.myBehaviour.getDataStore();
        }

        public synchronized void restart() {
            this.myBehaviour.restart();
        }

        private synchronized void go() {
            this.restarted = true;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                block10: {
                    ThreadedBehaviourFactory.this.threadedBehaviours.addElement(this);
                    do {
                        this.restarted = false;
                        this.myBehaviour.actionWrapper();
                        ThreadedBehaviour threadedBehaviour = this;
                        synchronized (threadedBehaviour) {
                            if (this.restarted) {
                                this.myBehaviour.setRunnable(true);
                            }
                            if (this.myBehaviour.done()) {
                                break block10;
                            }
                            if (!this.myBehaviour.isRunnable()) {
                                this.wait();
                            }
                        }
                    } while (!Thread.currentThread().isInterrupted());
                    throw new InterruptedException();
                }
                this.exitValue = this.myBehaviour.onEnd();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Threaded behaviour " + this.getBehaviourName() + " interrupted before termination");
            }
            catch (Agent.Interrupted interrupted) {
                System.out.println("Threaded behaviour " + this.getBehaviourName() + " interrupted before termination");
            }
            this.terminate();
        }

        private void interrupt() {
            this.myThread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void terminate() {
            this.finished = true;
            super.restart();
            ThreadedBehaviourFactory.this.threadedBehaviours.removeElement(this);
            ThreadedBehaviourFactory threadedBehaviourFactory = ThreadedBehaviourFactory.this;
            synchronized (threadedBehaviourFactory) {
                ThreadedBehaviourFactory.this.notifyAll();
            }
        }

        private final Thread getThread() {
            return this.myThread;
        }

        private final Behaviour getBehaviour() {
            return this.myBehaviour;
        }
    }
}

