/*
 * Decompiled with CFR 0.152.
 */
package jade.core.event;

import jade.core.AID;
import jade.core.Channel;
import jade.core.ContainerID;
import jade.core.event.JADEEvent;
import jade.lang.acl.ACLMessage;

public class MessageEvent
extends JADEEvent {
    public static final int SENT_MESSAGE = 1;
    public static final int POSTED_MESSAGE = 2;
    public static final int RECEIVED_MESSAGE = 3;
    public static final int ROUTED_MESSAGE = 4;
    private ACLMessage message = null;
    private AID sender = null;
    private AID receiver = null;
    private Channel from = null;
    private Channel to = null;

    public MessageEvent(int n, ACLMessage aCLMessage, AID aID, AID aID2, ContainerID containerID) {
        super(n, containerID);
        if (this.isRouting()) {
            throw new InternalError("Bad event kind: it must not be a 'message-routed' event.");
        }
        this.message = aCLMessage;
        this.sender = aID;
        this.receiver = aID2;
    }

    public MessageEvent(int n, ACLMessage aCLMessage, Channel channel, Channel channel2, ContainerID containerID) {
        super(n, containerID);
        if (!this.isRouting()) {
            throw new InternalError("Bad event kind: it must be a 'message-routed' event.");
        }
        this.message = aCLMessage;
        this.from = channel;
        this.to = channel2;
    }

    public ACLMessage getMessage() {
        return this.message;
    }

    public AID getSender() {
        if (this.sender != null) {
            return this.sender;
        }
        return this.message.getSender();
    }

    public AID getReceiver() {
        return this.receiver;
    }

    public AID getAgent() {
        if (this.type == 1) {
            return this.getSender();
        }
        return this.getReceiver();
    }

    public Channel getFrom() {
        return this.from;
    }

    public Channel getTo() {
        return this.to;
    }

    public boolean isRouting() {
        return this.type == 4;
    }
}

