/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.AgentContainer;
import jade.core.Filter;
import jade.core.VerticalCommand;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessagingService;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.LEAPACLCodec;
import jade.util.leap.Iterator;
import jade.util.leap.Map;
import java.util.Date;

public class OutgoingEncodingFilter
extends Filter {
    private Map messageEncodings;
    private AgentContainer myAgentContainer;
    private MessagingService myService;

    public OutgoingEncodingFilter(Map map, AgentContainer agentContainer, MessagingService messagingService) {
        this.messageEncodings = map;
        this.myAgentContainer = agentContainer;
        this.myService = messagingService;
        this.setPreferredPosition(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(VerticalCommand verticalCommand) {
        block10: {
            String string = verticalCommand.getName();
            Object[] objectArray = verticalCommand.getParams();
            if (!string.equals("Send-Message")) break block10;
            GenericMessage genericMessage = (GenericMessage)objectArray[1];
            AID aID = (AID)objectArray[0];
            AID aID2 = (AID)objectArray[2];
            ACLMessage aCLMessage = genericMessage.getACLMessage();
            try {
                if (aCLMessage.getSender().getName().length() < 1) {
                    aCLMessage.setSender(aID);
                }
            }
            catch (NullPointerException nullPointerException) {
                aCLMessage.setSender(aID);
            }
            AgentContainer agentContainer = this.myAgentContainer;
            synchronized (agentContainer) {
                if (this.myAgentContainer.acquireLocalAgent(aID2) != null) {
                    this.myAgentContainer.releaseLocalAgent(aID2);
                    return true;
                }
                this.prepareEnvelope(aCLMessage, aID2, genericMessage);
            }
            try {
                byte[] byArray = this.encodeMessage(aCLMessage);
                Envelope envelope = aCLMessage.getEnvelope();
                if (envelope != null) {
                    envelope.setPayloadLength(new Long(byArray.length));
                }
                ((GenericMessage)verticalCommand.getParams()[1]).update(aCLMessage, envelope, byArray);
            }
            catch (MessagingService.UnknownACLEncodingException unknownACLEncodingException) {
                unknownACLEncodingException.printStackTrace();
            }
        }
        return true;
    }

    public void prepareEnvelope(ACLMessage aCLMessage, AID aID, GenericMessage genericMessage) {
        Date date;
        Object object;
        Iterator iterator;
        Envelope envelope = aCLMessage.getEnvelope();
        String string = null;
        if (this.myService.livesHere(aID)) {
            if (envelope == null) {
                return;
            }
            string = LEAPACLCodec.NAME;
        } else {
            genericMessage.setForeignReceiver(true);
            if (envelope == null) {
                aCLMessage.setDefaultEnvelope();
                envelope = aCLMessage.getEnvelope();
            } else {
                string = "fipa.acl.rep.string.std";
            }
        }
        String string2 = envelope.getAclRepresentation();
        if (string2 == null) {
            envelope.setAclRepresentation(string);
        }
        if (!(iterator = envelope.getAllTo()).hasNext()) {
            object = aCLMessage.getAllReceiver();
            while (object.hasNext()) {
                envelope.addTo((AID)object.next());
            }
        }
        if ((object = envelope.getFrom()) == null) {
            envelope.setFrom(aCLMessage.getSender());
        }
        if ((date = envelope.getDate()) == null) {
            envelope.setDate(new Date());
        }
        envelope.clearAllIntendedReceiver();
        envelope.addIntendedReceiver(aID);
        Long l = envelope.getPayloadLength();
        if (l == null) {
            envelope.setPayloadLength(new Long(-1L));
        }
    }

    public byte[] encodeMessage(ACLMessage aCLMessage) throws MessagingService.UnknownACLEncodingException {
        String string;
        Envelope envelope = aCLMessage.getEnvelope();
        String string2 = string = envelope != null ? envelope.getAclRepresentation() : LEAPACLCodec.NAME;
        if (string != null) {
            ACLCodec aCLCodec = (ACLCodec)this.messageEncodings.get(string.toLowerCase());
            if (aCLCodec != null) {
                String string3;
                if (envelope == null || (string3 = envelope.getPayloadEncoding()) == null) {
                    string3 = "US-ASCII";
                }
                return aCLCodec.encode(aCLMessage, string3);
            }
            throw new MessagingService.UnknownACLEncodingException("Unknown ACL encoding: " + string + ".");
        }
        throw new MessagingService.UnknownACLEncodingException("No ACL encoding set.");
    }
}

