/*
 * Decompiled with CFR 0.152.
 */
package jade.core.nodeMonitoring;

import jade.core.Node;
import jade.util.Logger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

class UDPMonitorClient {
    private boolean running = false;
    private boolean terminating = false;
    private DatagramChannel channel;
    private String serverHost;
    private int serverPort;
    private ByteBuffer ping;
    private int pingDelay;
    private Node node;
    private Thread sender;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());

    public UDPMonitorClient(Node node, String string, int n, int n2) {
        this.node = node;
        this.serverHost = string;
        this.serverPort = n;
        this.pingDelay = n2;
    }

    public void start() throws IOException {
        this.channel = DatagramChannel.open();
        this.running = true;
        this.sender = new Thread(new Sender());
        this.sender.start();
        if (this.logger.isLoggable(Logger.INFO)) {
            this.logger.log(Logger.INFO, "UDP monitoring client has been started.");
        }
        if (this.logger.isLoggable(Logger.CONFIG)) {
            this.logger.log(Logger.CONFIG, "(Server host: '" + this.serverHost + "', ServerPort: " + this.serverPort + ", Ping delay: " + this.pingDelay + ")");
        }
    }

    public void stop() {
        this.terminating = true;
        this.sender.interrupt();
        if (this.logger.isLoggable(Logger.INFO)) {
            this.logger.log(Logger.INFO, "UDP monitoring client has been stopped.");
        }
    }

    private class Sender
    implements Runnable {
        private Sender() {
        }

        public void run() {
            block6: {
                while (UDPMonitorClient.this.running) {
                    this.updatePing();
                    try {
                        UDPMonitorClient.this.channel.send(UDPMonitorClient.this.ping, new InetSocketAddress(UDPMonitorClient.this.serverHost, UDPMonitorClient.this.serverPort));
                        Thread.sleep(UDPMonitorClient.this.pingDelay - 5);
                    }
                    catch (IOException iOException) {
                        if (!UDPMonitorClient.this.logger.isLoggable(Logger.SEVERE)) continue;
                        UDPMonitorClient.this.logger.log(Logger.SEVERE, "Error sending UDP ping message for node " + UDPMonitorClient.this.node.getName());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    UDPMonitorClient.this.channel.close();
                }
                catch (IOException iOException) {
                    if (!UDPMonitorClient.this.logger.isLoggable(Logger.FINER)) break block6;
                    UDPMonitorClient.this.logger.log(Logger.FINER, "Error closing UDP channel");
                }
            }
        }

        private void updatePing() {
            String string = UDPMonitorClient.this.node.getName();
            UDPMonitorClient.this.ping = ByteBuffer.allocate(4 + string.length() + 1);
            UDPMonitorClient.this.ping.position(0);
            UDPMonitorClient.this.ping.putInt(string.length());
            UDPMonitorClient.this.ping.put(string.getBytes());
            if (UDPMonitorClient.this.terminating) {
                UDPMonitorClient.this.ping.put((byte)1);
                UDPMonitorClient.this.running = false;
            } else {
                UDPMonitorClient.this.ping.put((byte)0);
            }
            UDPMonitorClient.this.ping.position(0);
        }
    }
}

