/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.lang.sl.SimpleSLTokenizer;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.WakerBehaviour;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.MissingParameter;
import jade.domain.FIPAAgentManagement.Property;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.domain.FIPAService;
import jade.domain.RequestFIPAServiceBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ISO8601;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.Date;

public class DFService
extends FIPAService {
    private static final long OFFSET = 10000L;
    private static final String SPACE_COLON = " :";
    private static final String SPACE_BRACKET = " (";
    private static Long MINUSONE = new Long(-1L);

    static void checkIsValid(DFAgentDescription dFAgentDescription, boolean bl) throws MissingParameter {
        try {
            if (dFAgentDescription.getName().getName().length() == 0) {
                throw new MissingParameter("df-agent-description", "name");
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new MissingParameter("df-agent-description", "name");
        }
        if (bl) {
            Iterator iterator = dFAgentDescription.getAllServices();
            while (iterator.hasNext()) {
                ServiceDescription serviceDescription = (ServiceDescription)iterator.next();
                if (serviceDescription.getName() == null) {
                    throw new MissingParameter("service-description", "name");
                }
                if (serviceDescription.getType() != null) continue;
                throw new MissingParameter("service-description", "type");
            }
        }
    }

    public static DFAgentDescription register(Agent agent, AID aID, DFAgentDescription dFAgentDescription) throws FIPAException {
        if (dFAgentDescription == null) {
            dFAgentDescription = new DFAgentDescription();
        }
        if (dFAgentDescription.getName() == null) {
            dFAgentDescription.setName(agent.getAID());
        }
        DFService.checkIsValid(dFAgentDescription, true);
        ACLMessage aCLMessage = DFService.createRequestMessage(agent, aID, "register", dFAgentDescription, null);
        ACLMessage aCLMessage2 = FIPAService.doFipaRequestClient(agent, aCLMessage);
        if (aCLMessage2 == null) {
            throw new FIPAException("Missing reply");
        }
        return DFService.decodeDone(aCLMessage2.getContent());
    }

    public static DFAgentDescription register(Agent agent, DFAgentDescription dFAgentDescription) throws FIPAException {
        return DFService.register(agent, agent.getDefaultDF(), dFAgentDescription);
    }

    public static void deregister(Agent agent, AID aID, DFAgentDescription dFAgentDescription) throws FIPAException {
        ACLMessage aCLMessage;
        ACLMessage aCLMessage2;
        if (dFAgentDescription == null) {
            dFAgentDescription = new DFAgentDescription();
        }
        if (dFAgentDescription.getName() == null) {
            dFAgentDescription.setName(agent.getAID());
        }
        if ((aCLMessage2 = FIPAService.doFipaRequestClient(agent, aCLMessage = DFService.createRequestMessage(agent, aID, "deregister", dFAgentDescription, null))) == null) {
            throw new FIPAException("Missing reply");
        }
    }

    public static void deregister(Agent agent, DFAgentDescription dFAgentDescription) throws FIPAException {
        DFService.deregister(agent, agent.getDefaultDF(), dFAgentDescription);
    }

    public static void deregister(Agent agent, AID aID) throws FIPAException {
        DFService.deregister(agent, aID, null);
    }

    public static void deregister(Agent agent) throws FIPAException {
        DFService.deregister(agent, agent.getDefaultDF());
    }

    public static DFAgentDescription modify(Agent agent, AID aID, DFAgentDescription dFAgentDescription) throws FIPAException {
        if (dFAgentDescription == null) {
            dFAgentDescription = new DFAgentDescription();
        }
        if (dFAgentDescription.getName() == null) {
            dFAgentDescription.setName(agent.getAID());
        }
        DFService.checkIsValid(dFAgentDescription, true);
        ACLMessage aCLMessage = DFService.createRequestMessage(agent, aID, "modify", dFAgentDescription, null);
        ACLMessage aCLMessage2 = FIPAService.doFipaRequestClient(agent, aCLMessage);
        if (aCLMessage2 == null) {
            throw new FIPAException("Missing reply");
        }
        return DFService.decodeDone(aCLMessage2.getContent());
    }

    public static DFAgentDescription modify(Agent agent, DFAgentDescription dFAgentDescription) throws FIPAException {
        return DFService.modify(agent, agent.getDefaultDF(), dFAgentDescription);
    }

    public static void keepRegistered(Agent agent, AID aID, final DFAgentDescription dFAgentDescription, Date date) {
        AID aID2;
        Date date2 = dFAgentDescription.getLeaseTime();
        AID aID3 = aID2 = aID != null ? aID : agent.getDefaultDF();
        if (date2 != null && (date == null || date2.getTime() < date.getTime())) {
            dFAgentDescription.setLeaseTime(date);
            agent.addBehaviour(new WakerBehaviour(agent, new Date(date2.getTime() - 10000L)){

                protected void handleElapsedTimeout() {
                    try {
                        DFAgentDescription dFAgentDescription2 = DFService.modify(this.myAgent, aID2, dFAgentDescription);
                        DFService.keepRegistered(this.myAgent, aID2, dFAgentDescription2, dFAgentDescription.getLeaseTime());
                    }
                    catch (FIPAException fIPAException) {
                        fIPAException.printStackTrace();
                    }
                }
            });
        }
    }

    public static DFAgentDescription[] search(Agent agent, AID aID, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints) throws FIPAException {
        ACLMessage aCLMessage;
        ACLMessage aCLMessage2;
        if (aID == null) {
            aID = agent.getDefaultDF();
        }
        if (dFAgentDescription == null) {
            dFAgentDescription = new DFAgentDescription();
        }
        if (searchConstraints == null) {
            searchConstraints = new SearchConstraints();
            searchConstraints.setMaxResults(MINUSONE);
        }
        if ((aCLMessage2 = FIPAService.doFipaRequestClient(agent, aCLMessage = DFService.createRequestMessage(agent, aID, "search", dFAgentDescription, searchConstraints))) == null) {
            throw new FIPAException("Missing reply");
        }
        return DFService.decodeResult(aCLMessage2.getContent());
    }

    public static DFAgentDescription[] search(Agent agent, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints) throws FIPAException {
        return DFService.search(agent, null, dFAgentDescription, searchConstraints);
    }

    public static DFAgentDescription[] search(Agent agent, DFAgentDescription dFAgentDescription) throws FIPAException {
        return DFService.search(agent, null, dFAgentDescription, null);
    }

    public static DFAgentDescription[] search(Agent agent, AID aID, DFAgentDescription dFAgentDescription) throws FIPAException {
        return DFService.search(agent, aID, dFAgentDescription, null);
    }

    public static DFAgentDescription[] searchUntilFound(Agent agent, AID aID, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints, long l) throws FIPAException {
        ACLMessage aCLMessage = DFService.createSubscriptionMessage(agent, aID, dFAgentDescription, searchConstraints);
        ACLMessage aCLMessage2 = FIPAService.doFipaRequestClient(agent, aCLMessage, l);
        ACLMessage aCLMessage3 = DFService.createCancelMessage(agent, aID, aCLMessage);
        agent.send(aCLMessage3);
        DFAgentDescription[] dFAgentDescriptionArray = null;
        if (aCLMessage2 != null) {
            dFAgentDescriptionArray = DFService.decodeNotification(aCLMessage2.getContent());
        }
        return dFAgentDescriptionArray;
    }

    public static ACLMessage createRequestMessage(Agent agent, AID aID, String string, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints) {
        ACLMessage aCLMessage = FIPAService.createRequestMessage(agent, aID);
        aCLMessage.setContent(DFService.encodeAction(aID, string, dFAgentDescription, searchConstraints));
        return aCLMessage;
    }

    public static ACLMessage createSubscriptionMessage(Agent agent, AID aID, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints) {
        ACLMessage aCLMessage = FIPAService.createRequestMessage(agent, aID);
        aCLMessage.setPerformative(19);
        aCLMessage.setProtocol("fipa-subscribe");
        aCLMessage.setLanguage("fipa-sl");
        aCLMessage.setContent(DFService.encodeIota(aID, dFAgentDescription, searchConstraints));
        return aCLMessage;
    }

    public static ACLMessage getSubscriptionMessage(Agent agent, AID aID, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints) throws FIPAException {
        return DFService.createSubscriptionMessage(agent, aID, dFAgentDescription, searchConstraints);
    }

    public static ACLMessage createCancelMessage(Agent agent, AID aID, ACLMessage aCLMessage) {
        ACLMessage aCLMessage2 = new ACLMessage(2);
        aCLMessage2.addReceiver(aID);
        aCLMessage2.setLanguage(aCLMessage.getLanguage());
        aCLMessage2.setOntology(aCLMessage.getOntology());
        aCLMessage2.setProtocol(aCLMessage.getProtocol());
        aCLMessage2.setConversationId(aCLMessage.getConversationId());
        aCLMessage2.setContent(DFService.encodeCancel(aID, aCLMessage));
        return aCLMessage2;
    }

    public static DFAgentDescription decodeDone(String string) throws FIPAException {
        try {
            int n = string.indexOf("df-agent-description");
            return DFService.parseDfd(new SimpleSLTokenizer(string.substring(n)));
        }
        catch (Exception exception) {
            throw new FIPAException("Error decoding INFORM Done. " + exception.getMessage());
        }
    }

    public static DFAgentDescription[] decodeResult(String string) throws FIPAException {
        try {
            int n = string.indexOf("action");
            n += DFService.countUntilEnclosing(string, n);
            return DFService.decodeDfdSequence(string.substring(n));
        }
        catch (Exception exception) {
            throw new FIPAException("Error decoding INFORM Result. " + exception.getMessage());
        }
    }

    public static DFAgentDescription[] decodeNotification(String string) throws FIPAException {
        try {
            int n = string.indexOf("iota");
            n += DFService.countUntilEnclosing(string, n);
            return DFService.decodeDfdSequence(string.substring(n));
        }
        catch (Exception exception) {
            throw new FIPAException("Error decoding INFORM Equals. " + exception.getMessage());
        }
    }

    private static DFAgentDescription parseDfd(SimpleSLTokenizer simpleSLTokenizer) throws Exception {
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        simpleSLTokenizer.getElement();
        while (simpleSLTokenizer.nextToken().startsWith(":")) {
            Iterator iterator;
            String string = simpleSLTokenizer.getElement();
            if (string.equals("name")) {
                simpleSLTokenizer.consumeChar('(');
                dFAgentDescription.setName(DFService.parseAID(simpleSLTokenizer));
                continue;
            }
            if (string.equals("lease-time")) {
                dFAgentDescription.setLeaseTime(ISO8601.toDate(simpleSLTokenizer.getElement()));
                continue;
            }
            if (string.equals("protocols")) {
                iterator = DFService.parseAggregate(simpleSLTokenizer).iterator();
                while (iterator.hasNext()) {
                    dFAgentDescription.addProtocols((String)iterator.next());
                }
                continue;
            }
            if (string.equals("languages")) {
                iterator = DFService.parseAggregate(simpleSLTokenizer).iterator();
                while (iterator.hasNext()) {
                    dFAgentDescription.addLanguages((String)iterator.next());
                }
                continue;
            }
            if (string.equals("ontologies")) {
                iterator = DFService.parseAggregate(simpleSLTokenizer).iterator();
                while (iterator.hasNext()) {
                    dFAgentDescription.addOntologies((String)iterator.next());
                }
                continue;
            }
            if (!string.equals("services")) continue;
            iterator = DFService.parseAggregate(simpleSLTokenizer).iterator();
            while (iterator.hasNext()) {
                dFAgentDescription.addServices((ServiceDescription)iterator.next());
            }
        }
        simpleSLTokenizer.consumeChar(')');
        return dFAgentDescription;
    }

    private static AID parseAID(SimpleSLTokenizer simpleSLTokenizer) throws Exception {
        AID aID = new AID("", true);
        simpleSLTokenizer.getElement();
        while (simpleSLTokenizer.nextToken().startsWith(":")) {
            Iterator iterator;
            String string = simpleSLTokenizer.getElement();
            if (string.equals("name")) {
                aID.setName(simpleSLTokenizer.getElement());
                continue;
            }
            if (string.equals("addresses")) {
                iterator = DFService.parseAggregate(simpleSLTokenizer).iterator();
                while (iterator.hasNext()) {
                    aID.addAddresses((String)iterator.next());
                }
                continue;
            }
            if (!string.equals("resolvers")) continue;
            iterator = DFService.parseAggregate(simpleSLTokenizer).iterator();
            while (iterator.hasNext()) {
                aID.addResolvers((AID)iterator.next());
            }
        }
        simpleSLTokenizer.consumeChar(')');
        return aID;
    }

    private static ServiceDescription parseServiceDescription(SimpleSLTokenizer simpleSLTokenizer) throws Exception {
        ServiceDescription serviceDescription = new ServiceDescription();
        simpleSLTokenizer.getElement();
        while (simpleSLTokenizer.nextToken().startsWith(":")) {
            Iterator iterator;
            String string = simpleSLTokenizer.getElement();
            if (string.equals("name")) {
                serviceDescription.setName(simpleSLTokenizer.getElement());
                continue;
            }
            if (string.equals("type")) {
                serviceDescription.setType(simpleSLTokenizer.getElement());
                continue;
            }
            if (string.equals("ownership")) {
                serviceDescription.setOwnership(simpleSLTokenizer.getElement());
                continue;
            }
            if (string.equals("protocols")) {
                iterator = DFService.parseAggregate(simpleSLTokenizer).iterator();
                while (iterator.hasNext()) {
                    serviceDescription.addProtocols((String)iterator.next());
                }
                continue;
            }
            if (string.equals("languages")) {
                iterator = DFService.parseAggregate(simpleSLTokenizer).iterator();
                while (iterator.hasNext()) {
                    serviceDescription.addLanguages((String)iterator.next());
                }
                continue;
            }
            if (string.equals("ontologies")) {
                iterator = DFService.parseAggregate(simpleSLTokenizer).iterator();
                while (iterator.hasNext()) {
                    serviceDescription.addOntologies((String)iterator.next());
                }
                continue;
            }
            if (!string.equals("properties")) continue;
            iterator = DFService.parseAggregate(simpleSLTokenizer).iterator();
            while (iterator.hasNext()) {
                serviceDescription.addProperties((Property)iterator.next());
            }
        }
        simpleSLTokenizer.consumeChar(')');
        return serviceDescription;
    }

    private static Property parseProperty(SimpleSLTokenizer simpleSLTokenizer) throws Exception {
        Property property = new Property();
        simpleSLTokenizer.getElement();
        while (simpleSLTokenizer.nextToken().startsWith(":")) {
            String string = simpleSLTokenizer.getElement();
            if (string.equals("name")) {
                property.setName(simpleSLTokenizer.getElement());
            }
            if (!string.equals("value")) continue;
            property.setValue(simpleSLTokenizer.getElement());
        }
        simpleSLTokenizer.consumeChar(')');
        return property;
    }

    private static List parseAggregate(SimpleSLTokenizer simpleSLTokenizer) throws Exception {
        ArrayList arrayList = new ArrayList();
        simpleSLTokenizer.consumeChar('(');
        simpleSLTokenizer.getElement();
        String string = simpleSLTokenizer.nextToken();
        while (!string.startsWith(")")) {
            if (!string.startsWith("(")) {
                arrayList.add(simpleSLTokenizer.getElement());
            } else {
                simpleSLTokenizer.consumeChar('(');
                string = simpleSLTokenizer.nextToken();
                if (string.equals("df-agent-description")) {
                    arrayList.add(DFService.parseDfd(simpleSLTokenizer));
                }
                if (string.equals("agent-identifier")) {
                    arrayList.add(DFService.parseAID(simpleSLTokenizer));
                } else if (string.equals("service-description")) {
                    arrayList.add(DFService.parseServiceDescription(simpleSLTokenizer));
                } else if (string.equals("property")) {
                    arrayList.add(DFService.parseProperty(simpleSLTokenizer));
                }
            }
            string = simpleSLTokenizer.nextToken();
        }
        simpleSLTokenizer.consumeChar(')');
        return arrayList;
    }

    private static DFAgentDescription[] decodeDfdSequence(String string) throws Exception {
        List list = DFService.parseAggregate(new SimpleSLTokenizer(string));
        DFAgentDescription[] dFAgentDescriptionArray = new DFAgentDescription[list.size()];
        int n = 0;
        while (n < list.size()) {
            dFAgentDescriptionArray[n] = (DFAgentDescription)list.get(n);
            ++n;
        }
        return dFAgentDescriptionArray;
    }

    private static int countUntilEnclosing(String string, int n) {
        int n2 = 1;
        boolean bl = false;
        int n3 = n;
        while (n2 > 0) {
            char c = string.charAt(n3++);
            if (!bl) {
                if (c == '(') {
                    ++n2;
                    continue;
                }
                if (c == ')') {
                    --n2;
                    continue;
                }
                if (c != '\"') continue;
                bl = true;
                continue;
            }
            if (c == '\\' && string.charAt(n3) == '\"') {
                ++n3;
                continue;
            }
            if (c != '\"') continue;
            bl = false;
        }
        return n3 - n;
    }

    static String encodeAction(AID aID, String string, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints) {
        StringBuffer stringBuffer = new StringBuffer("((");
        stringBuffer.append("action");
        stringBuffer.append(' ');
        stringBuffer.append(aID.toString());
        stringBuffer.append(SPACE_BRACKET);
        stringBuffer.append(string);
        stringBuffer.append(' ');
        DFService.encodeDfd(stringBuffer, dFAgentDescription);
        if (string.equals("search") && searchConstraints == null) {
            searchConstraints = new SearchConstraints();
            searchConstraints.setMaxResults(MINUSONE);
        }
        if (searchConstraints != null) {
            stringBuffer.append(SPACE_BRACKET);
            stringBuffer.append("search-constraints");
            DFService.encodeField(stringBuffer, searchConstraints.getMaxResults(), "max-results");
            DFService.encodeField(stringBuffer, searchConstraints.getMaxDepth(), "max-depth");
            DFService.encodeField(stringBuffer, searchConstraints.getSearchId(), "search-id");
            stringBuffer.append(')');
        }
        stringBuffer.append(")))");
        return stringBuffer.toString();
    }

    static String encodeIota(AID aID, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints) {
        StringBuffer stringBuffer = new StringBuffer("((iota ?x (");
        stringBuffer.append("result");
        stringBuffer.append(' ');
        String string = DFService.encodeAction(aID, "search", dFAgentDescription, searchConstraints);
        stringBuffer.append(string.substring(1, string.length() - 1));
        stringBuffer.append(" ?x)))");
        return stringBuffer.toString();
    }

    static String encodeCancel(AID aID, ACLMessage aCLMessage) {
        StringBuffer stringBuffer = new StringBuffer("((");
        stringBuffer.append("action");
        stringBuffer.append(' ');
        stringBuffer.append(aID.toString());
        stringBuffer.append(SPACE_BRACKET);
        stringBuffer.append(ACLMessage.getPerformative(aCLMessage.getPerformative()));
        DFService.encodeField(stringBuffer, aCLMessage.getSender(), "sender");
        DFService.encodeAggregate(stringBuffer, aCLMessage.getAllReceiver(), "sequence", "receivers");
        DFService.encodeField(stringBuffer, aCLMessage.getProtocol(), "protocol");
        DFService.encodeField(stringBuffer, aCLMessage.getLanguage(), "language");
        DFService.encodeField(stringBuffer, aCLMessage.getOntology(), "ontology");
        DFService.encodeField(stringBuffer, aCLMessage.getReplyWith(), "reply-with");
        DFService.encodeField(stringBuffer, aCLMessage.getConversationId(), "conversation-id");
        DFService.encodeField(stringBuffer, aCLMessage.getContent(), "content");
        stringBuffer.append(")))");
        return stringBuffer.toString();
    }

    private static void encodeDfd(StringBuffer stringBuffer, DFAgentDescription dFAgentDescription) {
        stringBuffer.append('(');
        stringBuffer.append("df-agent-description");
        DFService.encodeField(stringBuffer, dFAgentDescription.getName(), "name");
        DFService.encodeAggregate(stringBuffer, dFAgentDescription.getAllProtocols(), "set", "protocols");
        DFService.encodeAggregate(stringBuffer, dFAgentDescription.getAllLanguages(), "set", "languages");
        DFService.encodeAggregate(stringBuffer, dFAgentDescription.getAllOntologies(), "set", "ontologies");
        DFService.encodeAggregate(stringBuffer, dFAgentDescription.getAllServices(), "set", "services");
        Date date = dFAgentDescription.getLeaseTime();
        if (date != null) {
            stringBuffer.append(SPACE_COLON);
            stringBuffer.append("lease-time");
            stringBuffer.append(' ');
            stringBuffer.append(ISO8601.toString(date));
        }
        stringBuffer.append(')');
    }

    private static void encodeServiceDescription(StringBuffer stringBuffer, ServiceDescription serviceDescription) {
        stringBuffer.append('(');
        stringBuffer.append("service-description");
        DFService.encodeField(stringBuffer, serviceDescription.getName(), "name");
        DFService.encodeField(stringBuffer, serviceDescription.getType(), "type");
        DFService.encodeField(stringBuffer, serviceDescription.getOwnership(), "ownership");
        DFService.encodeAggregate(stringBuffer, serviceDescription.getAllProtocols(), "set", "protocols");
        DFService.encodeAggregate(stringBuffer, serviceDescription.getAllLanguages(), "set", "languages");
        DFService.encodeAggregate(stringBuffer, serviceDescription.getAllOntologies(), "set", "ontologies");
        DFService.encodeAggregate(stringBuffer, serviceDescription.getAllProperties(), "set", "properties");
        stringBuffer.append(')');
    }

    private static void encodeProperty(StringBuffer stringBuffer, Property property) {
        stringBuffer.append('(');
        stringBuffer.append("property");
        DFService.encodeField(stringBuffer, property.getName(), "name");
        DFService.encodeField(stringBuffer, property.getValue(), "value");
        stringBuffer.append(')');
    }

    private static void encodeField(StringBuffer stringBuffer, Object object, String string) {
        if (object != null) {
            stringBuffer.append(SPACE_COLON);
            stringBuffer.append(string);
            stringBuffer.append(' ');
            if (object instanceof String) {
                DFService.encodeString(stringBuffer, (String)object);
            } else {
                stringBuffer.append(object);
            }
        }
    }

    private static void encodeAggregate(StringBuffer stringBuffer, Iterator iterator, String string, String string2) {
        if (iterator != null && iterator.hasNext()) {
            stringBuffer.append(SPACE_COLON);
            stringBuffer.append(string2);
            stringBuffer.append(SPACE_BRACKET);
            stringBuffer.append(string);
            while (iterator.hasNext()) {
                stringBuffer.append(' ');
                Object e = iterator.next();
                if (e instanceof ServiceDescription) {
                    DFService.encodeServiceDescription(stringBuffer, (ServiceDescription)e);
                    continue;
                }
                if (e instanceof Property) {
                    DFService.encodeProperty(stringBuffer, (Property)e);
                    continue;
                }
                if (e instanceof String) {
                    DFService.encodeString(stringBuffer, (String)e);
                    continue;
                }
                stringBuffer.append(e);
            }
            stringBuffer.append(')');
        }
    }

    private static void encodeString(StringBuffer stringBuffer, String string) {
        if (SimpleSLTokenizer.isAWord(string)) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(SimpleSLTokenizer.quoteString(string));
        }
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent agent, AID aID, String string, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints) throws FIPAException {
        return new RequestFIPAServiceBehaviour(agent, aID, string, dFAgentDescription, searchConstraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent agent, String string, DFAgentDescription dFAgentDescription, SearchConstraints searchConstraints) throws FIPAException {
        return DFService.getNonBlockingBehaviour(agent, agent.getDefaultDF(), string, dFAgentDescription, searchConstraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent agent, String string) throws FIPAException {
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        dFAgentDescription.setName(agent.getAID());
        SearchConstraints searchConstraints = new SearchConstraints();
        searchConstraints.setMaxResults(MINUSONE);
        return DFService.getNonBlockingBehaviour(agent, agent.getDefaultDF(), string, dFAgentDescription, searchConstraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent agent, AID aID, String string) throws FIPAException {
        DFAgentDescription dFAgentDescription = new DFAgentDescription();
        dFAgentDescription.setName(agent.getAID());
        SearchConstraints searchConstraints = new SearchConstraints();
        searchConstraints.setMaxResults(MINUSONE);
        return DFService.getNonBlockingBehaviour(agent, aID, string, dFAgentDescription, searchConstraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent agent, String string, DFAgentDescription dFAgentDescription) throws FIPAException {
        SearchConstraints searchConstraints = new SearchConstraints();
        searchConstraints.setMaxResults(MINUSONE);
        return DFService.getNonBlockingBehaviour(agent, agent.getDefaultDF(), string, dFAgentDescription, searchConstraints);
    }

    public static RequestFIPAServiceBehaviour getNonBlockingBehaviour(Agent agent, AID aID, String string, DFAgentDescription dFAgentDescription) throws FIPAException {
        SearchConstraints searchConstraints = new SearchConstraints();
        searchConstraints.setMaxResults(MINUSONE);
        return DFService.getNonBlockingBehaviour(agent, aID, string, dFAgentDescription, searchConstraints);
    }
}

