/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.core.AID;
import jade.core.Agent;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

public class FIPAService {
    static ACLMessage createRequestMessage(Agent agent, AID aID) {
        ACLMessage aCLMessage = new ACLMessage(16);
        aCLMessage.setSender(agent.getAID());
        aCLMessage.addReceiver(aID);
        aCLMessage.setProtocol("fipa-request");
        aCLMessage.setLanguage("fipa-sl0");
        aCLMessage.setOntology("FIPA-Agent-Management");
        aCLMessage.setReplyWith("rw" + agent.getName() + System.currentTimeMillis());
        aCLMessage.setConversationId("conv" + agent.getName() + System.currentTimeMillis());
        return aCLMessage;
    }

    public static ACLMessage doFipaRequestClient(Agent agent, ACLMessage aCLMessage) throws FIPAException {
        return FIPAService.doFipaRequestClient(agent, aCLMessage, 0L);
    }

    public static ACLMessage doFipaRequestClient(Agent agent, ACLMessage aCLMessage, long l) throws FIPAException {
        if (aCLMessage.getReplyWith() == null) {
            aCLMessage.setReplyWith("rw" + agent.getLocalName() + System.currentTimeMillis());
        }
        long l2 = System.currentTimeMillis();
        agent.send(aCLMessage);
        MessageTemplate messageTemplate = MessageTemplate.MatchInReplyTo(aCLMessage.getReplyWith());
        ACLMessage aCLMessage2 = agent.blockingReceive(messageTemplate, l);
        if (aCLMessage2 != null) {
            if (aCLMessage2.getPerformative() == 7) {
                return aCLMessage2;
            }
            if (aCLMessage2.getPerformative() == 1) {
                long l3;
                if (l > 0L && (l -= (l3 = System.currentTimeMillis()) - l2) <= 0L) {
                    return null;
                }
                aCLMessage2 = agent.blockingReceive(messageTemplate, l);
            }
            if (aCLMessage2 != null) {
                if (aCLMessage2.getPerformative() == 7) {
                    return aCLMessage2;
                }
                throw new FIPAException(aCLMessage2.getContent());
            }
        }
        return null;
    }
}

