/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.ContentManager;
import jade.content.abs.AbsAgentAction;
import jade.content.abs.AbsIRE;
import jade.content.abs.AbsObjectImpl;
import jade.content.abs.AbsPredicate;
import jade.domain.DFMemKB;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.KBManagement.KB;
import jade.lang.acl.ACLMessage;
import jade.proto.SubscriptionResponder;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.io.Serializable;
import java.util.Enumeration;

class KBSubscriptionManager
implements SubscriptionResponder.SubscriptionManager {
    KB kBase;
    ContentManager cm;

    public KBSubscriptionManager(KB kB) {
        this.kBase = kB;
    }

    public void setContentManager(ContentManager contentManager) {
        this.cm = contentManager;
    }

    public boolean register(SubscriptionResponder.Subscription subscription) throws RefuseException, NotUnderstoodException {
        Object object;
        jade.util.leap.Serializable serializable;
        Serializable serializable2;
        Object object2;
        DFAgentDescription dFAgentDescription = null;
        SearchConstraints searchConstraints = null;
        AbsIRE absIRE = null;
        try {
            object2 = subscription.getMessage();
            absIRE = (AbsIRE)this.cm.extractAbsContent((ACLMessage)object2);
            serializable2 = absIRE.getProposition();
            serializable = (AbsAgentAction)((AbsObjectImpl)serializable2).getAbsObject("action");
            AbsAgentAction absAgentAction = (AbsAgentAction)((AbsObjectImpl)serializable).getAbsObject("action");
            object = (Search)FIPAManagementOntology.getInstance().toObject(absAgentAction);
            dFAgentDescription = (DFAgentDescription)((Search)object).getDescription();
            searchConstraints = ((Search)object).getConstraints();
            this.kBase.subscribe(dFAgentDescription, subscription);
        }
        catch (Exception exception) {
            throw new NotUnderstoodException(exception.getMessage());
        }
        object2 = this.kBase.search(dFAgentDescription);
        if (object2.size() > 0) {
            serializable2 = searchConstraints.getMaxResults();
            if (serializable2 != null && object2.size() >= ((Long)serializable2).intValue()) {
                serializable = new ArrayList();
                int n = 0;
                object = object2.iterator();
                while (object.hasNext() && n < ((Long)serializable2).intValue()) {
                    ((ArrayList)serializable).add(object.next());
                    ++n;
                }
                object2 = serializable;
            }
            this.notify(subscription, (List)object2, absIRE);
            return true;
        }
        return false;
    }

    public boolean deregister(SubscriptionResponder.Subscription subscription) throws FailureException {
        this.kBase.unsubscribe(subscription);
        return false;
    }

    private DFAgentDescription getDFAgentDescriptionFromACL(ACLMessage aCLMessage) {
        DFAgentDescription dFAgentDescription = null;
        try {
            AbsIRE absIRE = (AbsIRE)this.cm.extractAbsContent(aCLMessage);
            AbsPredicate absPredicate = absIRE.getProposition();
            AbsAgentAction absAgentAction = (AbsAgentAction)absPredicate.getAbsObject("action");
            AbsAgentAction absAgentAction2 = (AbsAgentAction)absAgentAction.getAbsObject("action");
            Search search = (Search)FIPAManagementOntology.getInstance().toObject(absAgentAction2);
            dFAgentDescription = (DFAgentDescription)search.getDescription();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return dFAgentDescription;
    }

    void handleChange(DFAgentDescription dFAgentDescription) {
        DFMemKB dFMemKB = new DFMemKB(0);
        Enumeration enumeration = this.kBase.getSubscriptions();
        while (enumeration.hasMoreElements()) {
            SubscriptionResponder.Subscription subscription = (SubscriptionResponder.Subscription)enumeration.nextElement();
            DFAgentDescription dFAgentDescription2 = this.getDFAgentDescriptionFromACL(subscription.getMessage());
            if (!dFMemKB.match(dFAgentDescription2, dFAgentDescription)) continue;
            ArrayList arrayList = new ArrayList();
            arrayList.add(dFAgentDescription);
            ACLMessage aCLMessage = subscription.getMessage();
            AbsIRE absIRE = null;
            try {
                absIRE = (AbsIRE)this.cm.extractAbsContent(aCLMessage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.notify(subscription, arrayList, absIRE);
        }
    }

    private void notify(SubscriptionResponder.Subscription subscription, List list, AbsIRE absIRE) {
        try {
            ACLMessage aCLMessage = subscription.getMessage().createReply();
            aCLMessage.setPerformative(7);
            AbsPredicate absPredicate = new AbsPredicate("=");
            absPredicate.set("left", absIRE);
            absPredicate.set("right", FIPAManagementOntology.getInstance().fromObject(list));
            this.cm.fillContent(aCLMessage, absPredicate);
            subscription.notify(aCLMessage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

