/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.Concept;
import jade.content.Predicate;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.lang.acl.ACLMessage;
import jade.proto.SimpleAchieveREInitiator;

class RemoteDFRequester
extends SimpleAchieveREInitiator {
    private AID remoteDF;
    private Concept myAction;
    private Object result = null;

    RemoteDFRequester(AID aID, Concept concept) {
        super(null, null);
        this.remoteDF = aID;
        this.myAction = concept;
    }

    protected ACLMessage prepareRequest(ACLMessage aCLMessage) {
        ACLMessage aCLMessage2 = new ACLMessage(16);
        aCLMessage2.addReceiver(this.remoteDF);
        aCLMessage2.setOntology(FIPAManagementOntology.getInstance().getName());
        aCLMessage2.setLanguage("fipa-sl0");
        aCLMessage2.setProtocol("fipa-request");
        Action action = new Action(this.remoteDF, this.myAction);
        try {
            this.myAgent.getContentManager().fillContent(aCLMessage2, action);
            return aCLMessage2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.result = new InternalError("Error encoding request [" + exception.getMessage() + "]");
            return null;
        }
    }

    protected void handleInform(ACLMessage aCLMessage) {
        try {
            Predicate predicate = (Predicate)this.myAgent.getContentManager().extractContent(aCLMessage);
            if (predicate instanceof Result) {
                this.result = ((Result)predicate).getValue();
            }
        }
        catch (Exception exception) {
            this.result = new InternalError("Error decoding response [" + exception.getMessage() + "]");
        }
    }

    protected void handleRefuse(ACLMessage aCLMessage) {
        this.result = new InternalError("Agent " + this.remoteDF.getName() + " replyed with " + ACLMessage.getPerformative(aCLMessage.getPerformative()));
    }

    protected void handleNotUnderstood(ACLMessage aCLMessage) {
        this.result = new InternalError("Agent " + this.remoteDF.getName() + " replyed with " + ACLMessage.getPerformative(aCLMessage.getPerformative()));
    }

    protected void handleFailure(ACLMessage aCLMessage) {
        this.result = new InternalError("Agent " + this.remoteDF.getName() + " replyed with " + ACLMessage.getPerformative(aCLMessage.getPerformative()));
    }

    protected Object getResult() {
        return this.result;
    }

    protected AID getRemoteDF() {
        return this.remoteDF;
    }

    protected Concept getAction() {
        return this.myAction;
    }
}

