/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.lang.Codec;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.core.Agent;
import jade.core.CaseInsensitiveString;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPAAgentManagement.UnsupportedValue;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.SimpleAchieveREResponder;
import jade.security.JADESecurityException;

public abstract class RequestManagementBehaviour
extends SimpleAchieveREResponder {
    private ACLMessage notification;

    protected RequestManagementBehaviour(Agent agent, MessageTemplate messageTemplate) {
        super(agent, messageTemplate);
    }

    protected abstract ACLMessage performAction(Action var1, ACLMessage var2) throws JADESecurityException, FIPAException;

    protected ACLMessage prepareResponse(ACLMessage aCLMessage) throws NotUnderstoodException, RefuseException {
        ACLMessage aCLMessage2 = null;
        try {
            this.isAnSLRequest(aCLMessage);
            Action action = (Action)this.myAgent.getContentManager().extractContent(aCLMessage);
            this.notification = this.performAction(action, aCLMessage);
        }
        catch (OntologyException ontologyException) {
            aCLMessage2 = aCLMessage.createReply();
            aCLMessage2.setPerformative(10);
            aCLMessage2.setContent("(unrecognised-value content)");
        }
        catch (Codec.CodecException codecException) {
            aCLMessage2 = aCLMessage.createReply();
            aCLMessage2.setPerformative(10);
            aCLMessage2.setContent("(unrecognised-value content)");
        }
        catch (RefuseException refuseException) {
            aCLMessage2 = aCLMessage.createReply();
            aCLMessage2.setPerformative(14);
            aCLMessage2.setContent(this.prepareErrorContent(aCLMessage.getContent(), refuseException.getMessage()));
        }
        catch (FailureException failureException) {
            this.notification = aCLMessage.createReply();
            this.notification.setPerformative(6);
            this.notification.setContent(this.prepareErrorContent(aCLMessage.getContent(), failureException.getMessage()));
        }
        catch (FIPAException fIPAException) {
            aCLMessage2 = aCLMessage.createReply();
            aCLMessage2.setPerformative(10);
            aCLMessage2.setContent("(" + fIPAException.getMessage() + ")");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.notification = aCLMessage.createReply();
            this.notification.setPerformative(6);
            this.notification.setContent(this.prepareErrorContent(aCLMessage.getContent(), "internal-error \"" + throwable.getMessage() + "\""));
        }
        return aCLMessage2;
    }

    protected ACLMessage prepareResultNotification(ACLMessage aCLMessage, ACLMessage aCLMessage2) throws FailureException {
        return this.notification;
    }

    public void reset() {
        super.reset();
        this.notification = null;
    }

    private void isAnSLRequest(ACLMessage aCLMessage) throws FIPAException {
        String string = aCLMessage.getLanguage();
        if (!(CaseInsensitiveString.equalsIgnoreCase("fipa-sl0", string) || CaseInsensitiveString.equalsIgnoreCase("fipa-sl1", string) || CaseInsensitiveString.equalsIgnoreCase("fipa-sl2", string) || CaseInsensitiveString.equalsIgnoreCase("fipa-sl", string))) {
            throw new UnsupportedValue("language");
        }
    }

    private String prepareErrorContent(String string, String string2) {
        String string3 = string.trim();
        string3 = string3.substring(1, string3.length() - 1);
        return "(" + string3 + " " + string2 + ")";
    }
}

