/*
 * Decompiled with CFR 0.152.
 */
package jade.domain.introspection;

import jade.content.lang.sl.SLCodec;
import jade.core.behaviours.CyclicBehaviour;
import jade.domain.introspection.Event;
import jade.domain.introspection.EventRecord;
import jade.domain.introspection.IntrospectionOntology;
import jade.domain.introspection.Occurred;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.leap.Serializable;
import java.util.Map;
import java.util.TreeMap;

public abstract class AMSSubscriber
extends CyclicBehaviour {
    public static final String AMS_SUBSCRIPTION = "tool-subscription";
    public static final String AMS_CANCELLATION = "tool-cancellation";
    public static final String PLATFORM_EVENTS = "platform-events";
    private ACLMessage AMSSubscription = new ACLMessage(19);
    private ACLMessage AMSCancellation = new ACLMessage(2);
    private MessageTemplate listenTemplate;
    private Map handlers = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public AMSSubscriber() {
        MessageTemplate messageTemplate = MessageTemplate.MatchLanguage("fipa-sl0");
        MessageTemplate messageTemplate2 = MessageTemplate.MatchOntology("JADE-Introspection");
        MessageTemplate messageTemplate3 = MessageTemplate.and(messageTemplate, messageTemplate2);
        messageTemplate = MessageTemplate.MatchInReplyTo(AMS_SUBSCRIPTION);
        messageTemplate2 = MessageTemplate.MatchPerformative(7);
        this.listenTemplate = MessageTemplate.and(messageTemplate, messageTemplate2);
        this.listenTemplate = MessageTemplate.and(this.listenTemplate, messageTemplate3);
        this.installHandlers(this.handlers);
    }

    public void onStart() {
        this.myAgent.getContentManager().registerOntology(IntrospectionOntology.getInstance());
        this.myAgent.getContentManager().registerLanguage(new SLCodec(), "fipa-sl0");
        this.AMSSubscription.addReceiver(this.myAgent.getAMS());
        this.AMSSubscription.setLanguage("fipa-sl0");
        this.AMSSubscription.setOntology("JADE-Introspection");
        this.AMSSubscription.setReplyWith(AMS_SUBSCRIPTION);
        this.AMSSubscription.setConversationId(this.myAgent.getLocalName());
        this.AMSSubscription.setContent(PLATFORM_EVENTS);
        this.AMSCancellation.addReceiver(this.myAgent.getAMS());
        this.AMSCancellation.setLanguage("fipa-sl0");
        this.AMSCancellation.setOntology("JADE-Introspection");
        this.AMSCancellation.setReplyWith(AMS_CANCELLATION);
        this.AMSCancellation.setConversationId(this.myAgent.getLocalName());
        this.myAgent.send(this.AMSSubscription);
    }

    protected abstract void installHandlers(Map var1);

    public final void action() {
        ACLMessage aCLMessage = this.myAgent.receive(this.listenTemplate);
        if (aCLMessage != null) {
            try {
                Occurred occurred = (Occurred)this.myAgent.getContentManager().extractContent(aCLMessage);
                EventRecord eventRecord = occurred.getWhat();
                Event event = eventRecord.getWhat();
                String string = event.getName();
                EventHandler eventHandler = (EventHandler)this.handlers.get(string);
                if (eventHandler != null) {
                    eventHandler.handle(event);
                }
            }
            catch (ClassCastException classCastException) {
                classCastException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.block();
        }
    }

    public final ACLMessage getSubscribe() {
        return this.AMSSubscription;
    }

    public final ACLMessage getCancel() {
        return this.AMSCancellation;
    }

    public static interface EventHandler
    extends Serializable {
        public void handle(Event var1);
    }
}

