/*
 * Decompiled with CFR 0.152.
 */
package jade.lang.acl;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.ACLMessage;
import jade.util.leap.Iterator;
import jade.util.leap.Properties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;

public class LEAPACLCodec
implements ACLCodec {
    public static String NAME = "leap.acl.rep";

    public byte[] encode(ACLMessage aCLMessage, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            LEAPACLCodec.serializeACL(aCLMessage, dataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ACLCodec.CodecException codecException) {
            codecException.printStackTrace();
        }
        return new byte[0];
    }

    public ACLMessage decode(byte[] byArray, String string) throws ACLCodec.CodecException {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            return LEAPACLCodec.deserializeACL(dataInputStream);
        }
        catch (IOException iOException) {
            throw new ACLCodec.CodecException(this.getName() + " ACLMessage decoding exception", iOException);
        }
    }

    public String getName() {
        return NAME;
    }

    public static final void serializeACL(ACLMessage aCLMessage, DataOutputStream dataOutputStream) throws IOException, ACLCodec.CodecException {
        dataOutputStream.writeByte(aCLMessage.getPerformative());
        int n = 0;
        int n2 = 0;
        AID aID = aCLMessage.getSender();
        String string = aCLMessage.getLanguage();
        String string2 = aCLMessage.getOntology();
        String string3 = aCLMessage.getEncoding();
        String string4 = aCLMessage.getProtocol();
        String string5 = aCLMessage.getConversationId();
        String string6 = aCLMessage.getInReplyTo();
        String string7 = aCLMessage.getReplyWith();
        Date date = aCLMessage.getReplyByDate();
        Envelope envelope = null;
        envelope = aCLMessage.getEnvelope();
        Properties properties = aCLMessage.getAllUserDefinedParameters();
        if (properties.size() > 63) {
            throw new ACLCodec.CodecException("Cannot serialize more than 63 params", null);
        }
        if (aID != null) {
            n = (byte)(n | 0x80);
        }
        if (string != null) {
            n = (byte)(n | 0x40);
        }
        if (string2 != null) {
            n = (byte)(n | 0x20);
        }
        if (string3 != null) {
            n = (byte)(n | 0x10);
        }
        if (string4 != null) {
            n = (byte)(n | 8);
        }
        if (string5 != null) {
            n = (byte)(n | 4);
        }
        if (string6 != null) {
            n = (byte)(n | 2);
        }
        if (string7 != null) {
            n = (byte)(n | 1);
        }
        if (date != null) {
            n2 = (byte)(n2 | 0x80);
        }
        if (envelope != null) {
            n2 = (byte)(n2 | 0x40);
        }
        n2 = (byte)(n2 | properties.size() & 0x3F);
        dataOutputStream.writeByte(n);
        dataOutputStream.writeByte(n2);
        if (aID != null) {
            LEAPACLCodec.serializeAID(aID, dataOutputStream);
        }
        if (string != null) {
            dataOutputStream.writeUTF(string);
        }
        if (string2 != null) {
            dataOutputStream.writeUTF(string2);
        }
        if (string3 != null) {
            dataOutputStream.writeUTF(string3);
        }
        if (string4 != null) {
            dataOutputStream.writeUTF(string4);
        }
        if (string5 != null) {
            dataOutputStream.writeUTF(string5);
        }
        if (string6 != null) {
            dataOutputStream.writeUTF(string6);
        }
        if (string7 != null) {
            dataOutputStream.writeUTF(string7);
        }
        if (date != null) {
            dataOutputStream.writeLong(date.getTime());
        }
        if (envelope != null) {
            LEAPACLCodec.serializeEnvelope(envelope, dataOutputStream);
        }
        LEAPACLCodec.serializeProperties(properties, dataOutputStream);
        Iterator iterator = aCLMessage.getAllReceiver();
        while (iterator.hasNext()) {
            dataOutputStream.writeBoolean(true);
            LEAPACLCodec.serializeAID((AID)iterator.next(), dataOutputStream);
        }
        dataOutputStream.writeBoolean(false);
        iterator = aCLMessage.getAllReplyTo();
        while (iterator.hasNext()) {
            dataOutputStream.writeBoolean(true);
            LEAPACLCodec.serializeAID((AID)iterator.next(), dataOutputStream);
        }
        dataOutputStream.writeBoolean(false);
        if (aCLMessage.hasByteSequenceContent()) {
            dataOutputStream.writeByte(2);
            byte[] byArray = aCLMessage.getByteSequenceContent();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
        } else {
            String string8 = aCLMessage.getContent();
            if (string8 != null) {
                dataOutputStream.writeByte(1);
                byte[] byArray = string8.getBytes();
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray, 0, byArray.length);
            } else {
                dataOutputStream.writeByte(0);
            }
        }
    }

    public static final ACLMessage deserializeACL(DataInputStream dataInputStream) throws IOException, ACLCodec.CodecException {
        Object object;
        ACLMessage aCLMessage = new ACLMessage(dataInputStream.readByte());
        byte by = dataInputStream.readByte();
        byte by2 = dataInputStream.readByte();
        if ((by & 0x80) != 0) {
            aCLMessage.setSender(LEAPACLCodec.deserializeAID(dataInputStream));
        }
        if ((by & 0x40) != 0) {
            aCLMessage.setLanguage(dataInputStream.readUTF());
        }
        if ((by & 0x20) != 0) {
            aCLMessage.setOntology(dataInputStream.readUTF());
        }
        if ((by & 0x10) != 0) {
            aCLMessage.setEncoding(dataInputStream.readUTF());
        }
        if ((by & 8) != 0) {
            aCLMessage.setProtocol(dataInputStream.readUTF());
        }
        if ((by & 4) != 0) {
            aCLMessage.setConversationId(dataInputStream.readUTF());
        }
        if ((by & 2) != 0) {
            aCLMessage.setInReplyTo(dataInputStream.readUTF());
        }
        if ((by & 1) != 0) {
            aCLMessage.setReplyWith(dataInputStream.readUTF());
        }
        if ((by2 & 0x80) != 0) {
            aCLMessage.setReplyByDate(new Date(dataInputStream.readLong()));
        }
        if ((by2 & 0x40) != 0) {
            aCLMessage.setEnvelope(LEAPACLCodec.deserializeEnvelope(dataInputStream));
        }
        int n = by2 & 0x3F;
        int n2 = 0;
        while (n2 < n) {
            String string = dataInputStream.readUTF();
            object = dataInputStream.readUTF();
            aCLMessage.addUserDefinedParameter(string, (String)object);
            ++n2;
        }
        while (dataInputStream.readBoolean()) {
            aCLMessage.addReceiver(LEAPACLCodec.deserializeAID(dataInputStream));
        }
        while (dataInputStream.readBoolean()) {
            aCLMessage.addReplyTo(LEAPACLCodec.deserializeAID(dataInputStream));
        }
        byte by3 = dataInputStream.readByte();
        if (by3 == 2) {
            object = new byte[dataInputStream.readInt()];
            dataInputStream.read((byte[])object, 0, ((Object)object).length);
            aCLMessage.setByteSequenceContent((byte[])object);
        } else if (by3 == 1) {
            object = new byte[dataInputStream.readInt()];
            dataInputStream.read((byte[])object, 0, ((Object)object).length);
            aCLMessage.setContent(new String((byte[])object));
        }
        return aCLMessage;
    }

    private static final void serializeAID(AID aID, DataOutputStream dataOutputStream) throws IOException, ACLCodec.CodecException {
        int n = 0;
        String string = aID.getName();
        Iterator iterator = aID.getAllAddresses();
        Iterator iterator2 = aID.getAllResolvers();
        Properties properties = aID.getAllUserDefinedSlot();
        if (properties.size() > 31) {
            throw new ACLCodec.CodecException("Cannot serialize more than 31 slots", null);
        }
        if (string != null) {
            n = (byte)(n | 0x80);
        }
        if (iterator.hasNext()) {
            n = (byte)(n | 0x40);
        }
        if (iterator2.hasNext()) {
            n = (byte)(n | 0x20);
        }
        n = (byte)(n | properties.size() & 0x1F);
        dataOutputStream.writeByte(n);
        if (string != null) {
            dataOutputStream.writeUTF(string);
        }
        while (iterator.hasNext()) {
            dataOutputStream.writeUTF((String)iterator.next());
            dataOutputStream.writeBoolean(iterator.hasNext());
        }
        while (iterator2.hasNext()) {
            LEAPACLCodec.serializeAID((AID)iterator2.next(), dataOutputStream);
            dataOutputStream.writeBoolean(iterator2.hasNext());
        }
        LEAPACLCodec.serializeProperties(properties, dataOutputStream);
    }

    private static final AID deserializeAID(DataInputStream dataInputStream) throws IOException, ACLCodec.CodecException {
        AID aID;
        byte by = dataInputStream.readByte();
        AID aID2 = aID = (by & 0x80) != 0 ? new AID(dataInputStream.readUTF(), true) : new AID();
        if ((by & 0x40) != 0) {
            do {
                aID.addAddresses(dataInputStream.readUTF());
            } while (dataInputStream.readBoolean());
        }
        if ((by & 0x20) != 0) {
            do {
                aID.addResolvers(LEAPACLCodec.deserializeAID(dataInputStream));
            } while (dataInputStream.readBoolean());
        }
        int n = by & 0x1F;
        int n2 = 0;
        while (n2 < n) {
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            aID.addUserDefinedSlot(string, string2);
            ++n2;
        }
        return aID;
    }

    private static final void serializeEnvelope(Envelope envelope, DataOutputStream dataOutputStream) throws IOException, ACLCodec.CodecException {
    }

    private static final Envelope deserializeEnvelope(DataInputStream dataInputStream) throws IOException, ACLCodec.CodecException {
        return null;
    }

    private static final void serializeProperties(Properties properties, DataOutputStream dataOutputStream) throws IOException, ACLCodec.CodecException {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeUTF(properties.getProperty(string));
        }
    }
}

