/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.Location;
import jade.core.NotFoundException;
import jade.wrapper.AgentState;
import jade.wrapper.ContainerProxy;
import jade.wrapper.StaleProxyException;
import jade.wrapper.State;

public class AgentController {
    public static final boolean ASYNC = false;
    public static final boolean SYNC = true;
    private AID agentID;
    private ContainerProxy myProxy;
    private AgentContainer myContainer;

    public AgentController(AID aID, ContainerProxy containerProxy, AgentContainer agentContainer) {
        this.agentID = aID;
        this.myProxy = containerProxy;
        this.myContainer = agentContainer;
    }

    public String getName() throws StaleProxyException {
        Agent agent = this.myContainer.acquireLocalAgent(this.agentID);
        if (agent == null) {
            throw new StaleProxyException("Controlled agent not found");
        }
        this.myContainer.releaseLocalAgent(this.agentID);
        return this.agentID.getName();
    }

    public void start() throws StaleProxyException {
        try {
            this.myContainer.powerUpLocalAgent(this.agentID);
        }
        catch (NotFoundException notFoundException) {
            throw new StaleProxyException("Controlled agent not found");
        }
    }

    public void suspend() throws StaleProxyException {
        try {
            this.myProxy.suspendAgent(this.agentID);
        }
        catch (Throwable throwable) {
            throw new StaleProxyException(throwable);
        }
    }

    public void activate() throws StaleProxyException {
        try {
            this.myProxy.activateAgent(this.agentID);
        }
        catch (Throwable throwable) {
            throw new StaleProxyException(throwable);
        }
    }

    public void kill() throws StaleProxyException {
        try {
            this.myProxy.killAgent(this.agentID);
        }
        catch (Throwable throwable) {
            throw new StaleProxyException(throwable);
        }
    }

    public void move(Location location) throws StaleProxyException {
        try {
            this.myProxy.moveAgent(this.agentID, location);
        }
        catch (Throwable throwable) {
            throw new StaleProxyException(throwable);
        }
    }

    public void clone(Location location, String string) throws StaleProxyException {
        try {
            this.myProxy.cloneAgent(this.agentID, location, string);
        }
        catch (Throwable throwable) {
            throw new StaleProxyException(throwable);
        }
    }

    public void putO2AObject(Object object, boolean bl) throws StaleProxyException {
        Agent agent = this.myContainer.acquireLocalAgent(this.agentID);
        if (agent == null) {
            throw new StaleProxyException("Controlled agent does not exist");
        }
        try {
            agent.putO2AObject(object, bl);
        }
        catch (InterruptedException interruptedException) {
            throw new StaleProxyException(interruptedException);
        }
        this.myContainer.releaseLocalAgent(this.agentID);
    }

    public State getState() throws StaleProxyException {
        Agent agent = this.myContainer.acquireLocalAgent(this.agentID);
        if (agent == null) {
            throw new StaleProxyException("Controlled agent does not exist");
        }
        int n = agent.getState();
        State state = null;
        switch (n) {
            case 1: {
                state = AgentState.AGENT_STATE_INITIATED;
                break;
            }
            case 2: {
                state = AgentState.AGENT_STATE_ACTIVE;
                break;
            }
            case 3: {
                state = AgentState.AGENT_STATE_IDLE;
                break;
            }
            case 4: {
                state = AgentState.AGENT_STATE_SUSPENDED;
                break;
            }
            case 5: {
                state = AgentState.AGENT_STATE_WAITING;
                break;
            }
            case 6: {
                state = AgentState.AGENT_STATE_DELETED;
                break;
            }
            default: {
                throw new InternalError("Unknown state: " + n);
            }
        }
        this.myContainer.releaseLocalAgent(this.agentID);
        return state;
    }
}

