/*
 * Decompiled with CFR 0.152.
 */
package jade.wrapper;

import jade.core.AgentManager;
import jade.core.ContainerID;
import jade.core.event.MTPEvent;
import jade.security.JADESecurityException;
import jade.wrapper.AgentController;
import jade.wrapper.ContainerController;
import jade.wrapper.ControllerException;
import jade.wrapper.PlatformController;
import jade.wrapper.PlatformEvent;
import jade.wrapper.PlatformState;
import jade.wrapper.State;
import java.util.Hashtable;

class PlatformControllerImpl
implements PlatformController {
    private ContainerController myContainer;
    private AgentManager myMain;
    private Hashtable listeners = new Hashtable();
    private State platformState = PlatformState.PLATFORM_STATE_VOID;

    PlatformControllerImpl(ContainerController containerController, AgentManager agentManager) {
        this.myContainer = containerController;
        this.myMain = agentManager;
        this.platformState = PlatformState.PLATFORM_STATE_READY;
        this.myMain.addListener(new AgentManagerListenerAdapter(){

            public void removedContainer(jade.core.event.PlatformEvent platformEvent) {
                ContainerID containerID = platformEvent.getContainer();
                try {
                    if (containerID.getName().equals(PlatformControllerImpl.this.myContainer.getContainerName())) {
                        PlatformControllerImpl.this.platformState = PlatformState.PLATFORM_STATE_KILLED;
                    }
                }
                catch (ControllerException controllerException) {
                    controllerException.printStackTrace();
                }
            }
        });
    }

    public String getName() {
        return this.myContainer.getPlatformName();
    }

    public void start() throws ControllerException {
    }

    public void suspend() throws ControllerException {
        throw new ControllerException("Not_Yet_Implemented");
    }

    public void resume() throws ControllerException {
        throw new ControllerException("Not_Yet_Implemented");
    }

    public void kill() throws ControllerException {
        try {
            this.platformState = PlatformState.PLATFORM_STATE_KILLING;
            this.myMain.shutdownPlatform(null, null);
        }
        catch (JADESecurityException jADESecurityException) {
            throw new ControllerException("Security error. " + jADESecurityException.getMessage());
        }
    }

    public AgentController getAgent(String string) throws ControllerException {
        return this.myContainer.getAgent(string);
    }

    public AgentController createNewAgent(String string, String string2, Object[] objectArray) throws ControllerException {
        return this.myContainer.createNewAgent(string, string2, objectArray);
    }

    public State getState() {
        return this.platformState;
    }

    public synchronized void addPlatformListener(PlatformController.Listener listener) throws ControllerException {
        ListenerWrapper listenerWrapper = new ListenerWrapper(listener);
        this.myMain.addListener(listenerWrapper);
        this.listeners.put(listener, listenerWrapper);
    }

    public synchronized void removePlatformListener(PlatformController.Listener listener) throws ControllerException {
        ListenerWrapper listenerWrapper = (ListenerWrapper)this.listeners.get(listener);
        if (listenerWrapper != null) {
            this.myMain.removeListener(listenerWrapper);
        }
    }

    class ListenerWrapper
    extends AgentManagerListenerAdapter {
        private PlatformController.Listener myListener;

        ListenerWrapper(PlatformController.Listener listener) {
            this.myListener = listener;
        }

        public void removedContainer(jade.core.event.PlatformEvent platformEvent) {
            ContainerID containerID = platformEvent.getContainer();
            try {
                if (containerID.getName().equals(PlatformControllerImpl.this.myContainer.getContainerName())) {
                    this.myListener.killedPlatform(new PlatformEvent(this){
                        private final /* synthetic */ ListenerWrapper this$1;
                        {
                            this.this$1 = listenerWrapper;
                        }

                        public String getAgentGUID() {
                            return null;
                        }

                        public String getPlatformName() {
                            return PlatformControllerImpl.access$000(ListenerWrapper.access$200(this.this$1)).getPlatformName();
                        }

                        public int getEventType() {
                            return 103;
                        }
                    });
                }
            }
            catch (ControllerException controllerException) {
                controllerException.printStackTrace();
            }
        }

        public void bornAgent(jade.core.event.PlatformEvent platformEvent) {
            this.myListener.bornAgent(platformEvent);
        }

        public void deadAgent(jade.core.event.PlatformEvent platformEvent) {
            this.myListener.deadAgent(platformEvent);
        }

        static /* synthetic */ PlatformControllerImpl access$200(ListenerWrapper listenerWrapper) {
            return listenerWrapper.PlatformControllerImpl.this;
        }
    }

    class AgentManagerListenerAdapter
    implements AgentManager.Listener {
        AgentManagerListenerAdapter() {
        }

        public void addedContainer(jade.core.event.PlatformEvent platformEvent) {
        }

        public void removedContainer(jade.core.event.PlatformEvent platformEvent) {
        }

        public void bornAgent(jade.core.event.PlatformEvent platformEvent) {
        }

        public void deadAgent(jade.core.event.PlatformEvent platformEvent) {
        }

        public void movedAgent(jade.core.event.PlatformEvent platformEvent) {
        }

        public void suspendedAgent(jade.core.event.PlatformEvent platformEvent) {
        }

        public void resumedAgent(jade.core.event.PlatformEvent platformEvent) {
        }

        public void frozenAgent(jade.core.event.PlatformEvent platformEvent) {
        }

        public void thawedAgent(jade.core.event.PlatformEvent platformEvent) {
        }

        public void addedMTP(MTPEvent mTPEvent) {
        }

        public void removedMTP(MTPEvent mTPEvent) {
        }

        public void messageIn(MTPEvent mTPEvent) {
        }

        public void messageOut(MTPEvent mTPEvent) {
        }
    }
}

