/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.iiop;

import FIPA.AgentID;
import FIPA.DateTime;
import FIPA.FipaMessage;
import FIPA.MTS;
import FIPA.Property;
import FIPA.ReceivedObject;
import FIPA._MTSImplBase;
import jade.core.AID;
import jade.core.Profile;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.mtp.InChannel;
import jade.mtp.MTP;
import jade.mtp.MTPException;
import jade.mtp.TransportAddress;
import jade.mtp.iiop.IIOPAddress;
import jade.util.leap.Iterator;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class MessageTransportProtocol
implements MTP {
    private static final String[] PROTOCOLS = new String[]{"IOR", "corbaloc", "corbaname"};
    private final ORB myORB = ORB.init((String[])new String[0], null);
    private MTSImpl server;
    private static PrintWriter logFile;

    public TransportAddress activate(InChannel.Dispatcher dispatcher, Profile profile) throws MTPException {
        this.server = new MTSImpl(dispatcher);
        this.myORB.connect((Object)this.server);
        IIOPAddress iIOPAddress = new IIOPAddress(this.myORB, this.server);
        return iIOPAddress;
    }

    public void activate(InChannel.Dispatcher dispatcher, TransportAddress transportAddress, Profile profile) throws MTPException {
        IIOPAddress iIOPAddress = (IIOPAddress)transportAddress;
        IIOPAddress iIOPAddress2 = (IIOPAddress)this.activate(dispatcher, profile);
        iIOPAddress.initFromIOR(iIOPAddress2.getIOR());
    }

    public void deactivate(TransportAddress transportAddress) throws MTPException {
        this.myORB.disconnect((Object)this.server);
    }

    public void deactivate() throws MTPException {
        this.myORB.disconnect((Object)this.server);
    }

    public void deliver(String string, Envelope envelope, byte[] byArray) throws MTPException {
        try {
            jade.domain.FIPAAgentManagement.Property property;
            AID aID;
            AID aID2;
            TransportAddress transportAddress = this.strToAddr(string);
            IIOPAddress iIOPAddress = (IIOPAddress)transportAddress;
            MTS mTS = iIOPAddress.getObject();
            if (mTS._non_existent()) {
                throw new MTPException("Bad IIOP server object reference:" + mTS.toString());
            }
            Iterator iterator = envelope.getAllTo();
            ArrayList<AgentID> arrayList = new ArrayList<AgentID>();
            while (iterator.hasNext()) {
                aID2 = (AID)iterator.next();
                arrayList.add(this.marshalAID(aID2));
            }
            aID2 = new AgentID[arrayList.size()];
            int n = 0;
            while (n < arrayList.size()) {
                aID2[n] = (AgentID)arrayList.get(n);
                ++n;
            }
            AID aID3 = envelope.getFrom();
            AgentID[] agentIDArray = new AgentID[]{this.marshalAID(aID3)};
            Iterator iterator2 = envelope.getAllIntendedReceiver();
            ArrayList<AgentID> arrayList2 = new ArrayList<AgentID>();
            while (iterator2.hasNext()) {
                aID = (AID)iterator2.next();
                arrayList2.add(this.marshalAID(aID));
            }
            aID = new AgentID[arrayList2.size()];
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                aID[n2] = (AgentID)arrayList2.get(n2);
                ++n2;
            }
            String[] stringArray = new String[]{};
            String string2 = envelope.getComments() != null ? envelope.getComments() : "";
            String string3 = envelope.getAclRepresentation();
            Long l = envelope.getPayloadLength();
            int n3 = l.intValue();
            String string4 = envelope.getPayloadEncoding() != null ? envelope.getPayloadEncoding() : "";
            DateTime[] dateTimeArray = new DateTime[]{this.marshalDateTime(envelope.getDate())};
            Property[][] propertyArray = new Property[][]{};
            Iterator iterator3 = envelope.getAllProperties();
            ArrayList<Property> arrayList3 = new ArrayList<Property>();
            while (iterator3.hasNext()) {
                property = (jade.domain.FIPAAgentManagement.Property)iterator3.next();
                arrayList3.add(this.marshalProperty(property));
            }
            property = new Property[arrayList3.size()];
            int n4 = 0;
            while (n4 < arrayList3.size()) {
                property[n4] = (Property)arrayList3.get(n4);
                ++n4;
            }
            jade.domain.FIPAAgentManagement.ReceivedObject receivedObject = envelope.getReceived();
            ReceivedObject[] receivedObjectArray = receivedObject != null ? new ReceivedObject[]{this.marshalReceivedObj(receivedObject)} : new ReceivedObject[]{};
            FIPA.Envelope envelope2 = new FIPA.Envelope((AgentID[])aID2, agentIDArray, string2, string3, n3, string4, dateTimeArray, stringArray, (AgentID[])aID, receivedObjectArray, propertyArray, (Property[])property);
            FipaMessage fipaMessage = new FipaMessage(new FIPA.Envelope[]{envelope2}, byArray);
            mTS.message(fipaMessage);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            throw new MTPException("Address mismatch: this is not a valid IIOP address.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MTPException("Address mismatch: this is not a valid IIOP address.");
        }
    }

    public TransportAddress strToAddr(String string) throws MTPException {
        return new IIOPAddress(this.myORB, string);
    }

    public String addrToStr(TransportAddress transportAddress) throws MTPException {
        try {
            IIOPAddress iIOPAddress = (IIOPAddress)transportAddress;
            return iIOPAddress.getIOR();
        }
        catch (ClassCastException classCastException) {
            throw new MTPException("Address mismatch: this is not a valid IIOP address.");
        }
    }

    public String getName() {
        return "fipa.mts.mtp.iiop.std";
    }

    public String[] getSupportedProtocols() {
        return PROTOCOLS;
    }

    private Property marshalProperty(jade.domain.FIPAAgentManagement.Property property) {
        Any any = this.myORB.create_any();
        java.lang.Object object = property.getValue();
        if (object instanceof Serializable) {
            any.insert_Value((Serializable)object);
        } else if (object != null) {
            any.insert_Value((Serializable)((java.lang.Object)object.toString()));
        }
        return new Property(property.getName(), any);
    }

    private AgentID marshalAID(AID aID) {
        String string = aID.getName();
        String[] stringArray = aID.getAddressesArray();
        AID[] aIDArray = aID.getResolversArray();
        Property[] propertyArray = new Property[]{};
        int n = aIDArray.length;
        AgentID agentID = new AgentID(string, stringArray, new AgentID[n], propertyArray);
        int n2 = 0;
        while (n2 < n) {
            agentID.resolvers[n2] = this.marshalAID(aIDArray[n2]);
            ++n2;
        }
        return agentID;
    }

    private DateTime marshalDateTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        short s = (short)calendar.get(1);
        short s2 = (short)calendar.get(2);
        short s3 = (short)calendar.get(5);
        short s4 = (short)calendar.get(11);
        short s5 = (short)calendar.get(12);
        short s6 = (short)calendar.get(13);
        short s7 = 0;
        char c = ' ';
        DateTime dateTime = new DateTime(s, s2, s3, s4, s5, s6, s7, c);
        return dateTime;
    }

    private ReceivedObject marshalReceivedObj(jade.domain.FIPAAgentManagement.ReceivedObject receivedObject) {
        ReceivedObject receivedObject2 = new ReceivedObject();
        receivedObject2.by = receivedObject.getBy();
        receivedObject2.from = receivedObject.getFrom();
        receivedObject2.date = this.marshalDateTime(receivedObject.getDate());
        receivedObject2.id = receivedObject.getId();
        receivedObject2.via = receivedObject.getVia();
        return receivedObject2;
    }

    private static class MTSImpl
    extends _MTSImplBase {
        private final InChannel.Dispatcher dispatcher;

        public MTSImpl(InChannel.Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }

        public void message(FipaMessage fipaMessage) {
            FIPA.Envelope[] envelopeArray = fipaMessage.messageEnvelopes;
            byte[] byArray = fipaMessage.messageBody;
            Envelope envelope = new Envelope();
            int n = 0;
            while (n < envelopeArray.length) {
                java.lang.Object object;
                AID aID;
                FIPA.Envelope envelope2 = envelopeArray[n];
                if (envelope2.to.length > 0) {
                    envelope.clearAllTo();
                }
                int n2 = 0;
                while (n2 < envelope2.to.length) {
                    aID = this.unmarshalAID(envelope2.to[n2]);
                    envelope.addTo(aID);
                    ++n2;
                }
                if (envelope2.from.length > 0) {
                    aID = this.unmarshalAID(envelope2.from[0]);
                    envelope.setFrom(aID);
                }
                if (envelope2.intendedReceiver.length > 0) {
                    envelope.clearAllIntendedReceiver();
                }
                int n3 = 0;
                while (n3 < envelope2.intendedReceiver.length) {
                    object = this.unmarshalAID(envelope2.intendedReceiver[n3]);
                    envelope.addIntendedReceiver(object);
                    ++n3;
                }
                if (envelope2.comments.length() > 0) {
                    envelope.setComments(envelope2.comments);
                }
                if (envelope2.aclRepresentation.length() > 0) {
                    envelope.setAclRepresentation(envelope2.aclRepresentation);
                }
                if (envelope2.payloadLength > 0) {
                    envelope.setPayloadLength(new Long(envelope2.payloadLength));
                }
                if (envelope2.payloadEncoding.length() > 0) {
                    envelope.setPayloadEncoding(envelope2.payloadEncoding);
                }
                if (envelope2.date.length > 0) {
                    object = this.unmarshalDateTime(envelope2.date[0]);
                    envelope.setDate((Date)object);
                }
                if (envelope2.received.length > 0) {
                    envelope.addStamp(this.unmarshalReceivedObj(envelope2.received[0]));
                }
                if (envelope2.userDefinedProperties.length > 0) {
                    envelope.clearAllProperties();
                }
                int n4 = 0;
                while (n4 < envelope2.userDefinedProperties.length) {
                    envelope.addProperties(this.unmarshalProperty(envelope2.userDefinedProperties[n4]));
                    ++n4;
                }
                ++n;
            }
            this.dispatcher.dispatchMessage(envelope, byArray);
        }

        private AID unmarshalAID(AgentID agentID) {
            AID aID = new AID();
            aID.setName(agentID.name);
            int n = 0;
            while (n < agentID.addresses.length) {
                aID.addAddresses(agentID.addresses[n]);
                ++n;
            }
            int n2 = 0;
            while (n2 < agentID.resolvers.length) {
                aID.addResolvers(this.unmarshalAID(agentID.resolvers[n2]));
                ++n2;
            }
            return aID;
        }

        private Date unmarshalDateTime(DateTime dateTime) {
            Date date = new Date();
            return date;
        }

        private jade.domain.FIPAAgentManagement.Property unmarshalProperty(Property property) {
            return new jade.domain.FIPAAgentManagement.Property(property.keyword, (java.lang.Object)property.value.extract_Value());
        }

        private jade.domain.FIPAAgentManagement.ReceivedObject unmarshalReceivedObj(ReceivedObject receivedObject) {
            jade.domain.FIPAAgentManagement.ReceivedObject receivedObject2 = new jade.domain.FIPAAgentManagement.ReceivedObject();
            receivedObject2.setBy(receivedObject.by);
            receivedObject2.setFrom(receivedObject.from);
            receivedObject2.setDate(this.unmarshalDateTime(receivedObject.date));
            receivedObject2.setId(receivedObject.id);
            receivedObject2.setVia(receivedObject.via);
            return receivedObject2;
        }
    }
}

