#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <vector>
#include <iostream>
using namespace std;


// -------------------------------------------------------------
// class PARAMETER 
// -------------------------------------------------------------

class PARAMETER {
	char* name;

public: 

	PARAMETER(const char* name2) {
		name=new char[strlen(name2)+1];
		strcpy(name,name2);
	}

	PARAMETER(const PARAMETER &param2) {
		name=new char[strlen(param2.name)+1];
		strcpy(name,param2.name);
	}

	~PARAMETER() {
		if (name) delete [] name;
	}

	friend ostream& operator<< (ostream &out, PARAMETER &para) {
		return out << para.name;
	}

	friend bool operator== (PARAMETER &para1, PARAMETER &para2) {
		return strcmp(para1.name,para2.name)==0;
	}
};


// -------------------------------------------------------------
// class PARAMETERS
// -------------------------------------------------------------

//typedef vector<PARAMETER> PARAMETERS;

class PARAMETERS : public vector<PARAMETER>{

public:

	friend ostream& operator<< (ostream &out, PARAMETERS &params) {
		iterator it;
		if (params.empty()) return out;
		it=params.begin();
		out << "(" << *it++;
		while (it != params.end()) out << ", " << *it++;
		out << ")" ;
		return out;
	}

	friend bool operator== (PARAMETERS &param1,PARAMETERS &param2) {
		vector<PARAMETER>::iterator it1,it2;
		int num;
		bool used[1000];

		for (int i=0;i<param2.size()+2;i++) used[i]=false;

		for( it1 = param1.begin(); it1 != param1.end(); it1++ ) {
			it2 = param2.begin();
			num=0;
			bool finish=false;
			while (!finish && it2!= param2.end()) {
				if (!used[num] && *it1==*it2) {
					used[num]=true;
					finish=true;
				} 
				else {
					it2++;
					num++;
				}
			}
			if (it2==param2.end()) return false;
		}
		return true;
	}
};



// -------------------------------------------------------------
// class ATOM
// -------------------------------------------------------------

class ATOM {
	bool isTrueNeg;
	char* name;
	PARAMETERS parameters;
	
public:

	ATOM(const bool isTrueNeg2, const char *name2){
		isTrueNeg = isTrueNeg2;
		name=new char[strlen(name2)+1];
		strcpy(name,name2);
	}

	friend ostream& operator<< (ostream &out,ATOM &atom) {
		if (atom.isTrueNeg) out << "-";
		out << atom.name << atom.parameters;
		return out;
	}

	friend bool operator== (ATOM& atom1, ATOM& atom2) {

		if (atom1.isTrueNeg!=atom2.isTrueNeg) 
			return false;

		if (strcmp(atom1.name,atom2.name)) 
			return false;

		if (atom1.parameters.size()!=atom2.parameters.size()) 
			return false;

		return (atom1.parameters==atom2.parameters);
	}

	void addparam(const char* param) {
		parameters.push_back(param);
	}

	void addparam(const PARAMETER param) {
		parameters.push_back(param);
	}

	void setnegation(const bool trueneg){
		isTrueNeg=trueneg;
	}

	bool isnegated(){
		return isTrueNeg;
	}

  };


// -------------------------------------------------------------
// class ATOMS
// -------------------------------------------------------------

class ATOMS : public vector<ATOM>{

public:


	friend ostream& operator<< (ostream &out, ATOMS &atoms) {
		iterator it;
		if (atoms.empty()) return out;
		it=atoms.begin();
		out << *it++;
		while (it != atoms.end()) out << ", " << *it++;
		return out;
	}

	friend bool operator== (ATOMS& atoms1, ATOMS& atoms2) {

		if (atoms1.size()!=atoms2.size()) return false;

		bool used[1000];
		int i,j,num;

		for (i=0;i<atoms2.size()+2;i++) 
			used[i]=false;

		vector<ATOM>::iterator it1,it2;
		
		for( it1 = atoms1.begin(); it1 != atoms1.end(); it1++ ) {

			it2 = atoms2.begin();
			num=0;
			bool finish=false;

			while (!finish && it2!= atoms2.end()) {

				if (!used[num] && *it1==*it2) {
					used[num]=true;
					finish=true;

				} 
				else {
					it2++;
					num++;
				}
			}

			if (it2==atoms2.end()) return false;
		}

		return true;
	}

 };


// -------------------------------------------------------------
// method endofplan
// -------------------------------------------------------------

bool endofplan(FILE *input) {
	char buffer[1024];
	if (feof(input)) return true;
	fgets(buffer,1024,input);
	return (strncmp(buffer,"PLAN:",5)==0);
}


// -------------------------------------------------------------
// method scanstate
// -------------------------------------------------------------

ATOMS* scanstate(FILE *input) {

	ATOMS* point=new ATOMS();
	char* buffer,*buffer2,*name;
	int stateno;

	buffer=new char[1024];
	name=new char[1024];

	fgets(buffer,1024,input);

	if (strncmp(buffer,"STATE ",6)) { 

		return NULL;
	}  
	else {
		buffer+=6;
		sscanf(buffer,"%d",&stateno);

		while(buffer[0]!=' ') buffer++;
		buffer++;

		while(buffer[0]>=' '){

			bool negation=(buffer[0]=='-' || buffer[0]=='~');

			if (negation) 
				buffer++;
			buffer2=buffer;

			while ((buffer[1]!=' ' || buffer[0]!=',') && buffer[0]>=' ') 
				buffer++;

			if (buffer[0]==',') {
				buffer[0]=0;
				buffer+=2;
			} 
			else 
				buffer[0]=0;

			strcpy(name,buffer2);

			ATOM temp(negation,name);

			(*point).push_back(temp);

		}
		
		return point;
	}
}

// -------------------------------------------------------------
// method MAIN
// -------------------------------------------------------------

int main(int argc, char* argv[]) {
	
	FILE *Traj, *Plan;
	bool match,history=false;

	if (argc<3) {
		fprintf(stderr,"ERROR: Enter two trajectory files as parameters!\n"); 
		exit(1); 
	}
	
	Traj=fopen(argv[1],"r");
	Plan=fopen(argv[2],"r");
	
	if (argc>3) if (!strcmp(argv[3],"-history")) 
		history=true;
	
	if (history) 
		fprintf(stderr,"   >   History-oriented diagnosis enabled.\n");
	else 
		fprintf(stderr,"   >   State-oriented diagnosis enabled.\n");


	ATOMS* states[250];
	ATOMS* trajectory[500][250];
	int lengths[10000];
	int totaltrajs=0;
	int ispof[10000];


	lengths[0]=0;
	
	while(!feof(Traj)) {

		while (1) {

			trajectory[totaltrajs][lengths[totaltrajs]++]=scanstate(Traj);
			ispof[totaltrajs]=-1;

			if (endofplan(Traj)) 
				break;
		}

		lengths[++totaltrajs]=0; 
	}
	
	if(trajectory[totaltrajs-1][0]==NULL) 
		totaltrajs--;
	
	int pof=-1;
	while(!feof(Plan)) {

		int totalstates=0;

		while (1) {

			states[totalstates++]=scanstate(Plan);

			if (endofplan(Plan)) 
				break;
		}
		
		if (states[totalstates-1]==NULL) 
			break;
		
		fprintf(stderr,"   >   Scanned evolution of length 0..%d\n",totalstates-1);

		int i,j;
		j=totalstates-1;//2
		
		while(j>=pof) {

			for (int traj=0;traj<totaltrajs;traj++) 

				if (ispof[traj]<j) {

					fprintf(stderr,"   >>  Looking at preferred trajectory %d, state #%d",traj,j);

					if (!history) 
						match=(*trajectory[traj][j])==(*states[j]);

					if (history) {
						int k=j;

						while (k>=0 && *trajectory[traj][k]==*states[k]) 
							k--;

						match=k<0;
					} 

					if (match) {
						fprintf(stderr,": MATCH!\n");
						ispof[traj]=j;
						pof=j;
						if (j==totalstates-1) pof=250;
					} 
					else 
						fprintf(stderr,".\n");
				}
				j--;
		}
		if (pof>=0) 
			fprintf(stderr,"   >   Current point of failure: %d\n",pof);
		else 
			fprintf       (stderr,"   >   Current point of failure: NONE\n");
	}

	if (pof>249) {
		printf("No discrepancy detected.\n");
	} 
	else 
		if (pof>=0) {
			printf("Point(s) of failure at stage %d;\nFailure state(s):\n",pof);

			for (int i=0;i<totaltrajs;i++)  {
				if (i>0) 
					cout << endl;
				if (ispof[i]==pof) 
					cout << *trajectory[i][pof] << endl;
			}
		} 
		else {
			printf("No point of failure diagnosed.\n");
		}
		exit (pof);


}
